proc(y)=pantime(z,T)
; ---------------------------------------------------------------------
; Library     metrics
; ---------------------------------------------------------------------
; See_also    panfix, panrand, panhaus
; ---------------------------------------------------------------------
; Macro       pantime
; ---------------------------------------------------------------------
; Description Subtracts the mean of period t 
;             from the model variables. 
;             Purpose: Accounting for fixed time effects
; ---------------------------------------------------------------------
; Usage       y = pantime(z,{T})
; Input       
; Parameter   z
; Definition     Data matrix. First column: Identification number for
;                cross section units (optional), Second column: depen-
;                dent variable, Further columns: explanatory variables
; Parameter   T  
; Definition     (optional) for producing the identification numbers
;                for a balanced data set
; Output      
; Parameter   y
; Definition     Data matrix 
; ---------------------------------------------------------------------
; Example       library("metrics")
;              	z=read("earnings")
;		y=pantime(z)
;		z[1:10,1:3]~y[1:10,3]   
; ---------------------------------------------------------------------
; Result      Contents of _tmp
; [ 1,]        1        1     2600   1694.7 
; [ 2,]        1        2     2500   1385.3 
; [ 3,]        1        3     2700   1504.8 
; [ 4,]        1        4     3400   2674.3 
; [ 5,]        1        5     3354   2157.7 
; [ 6,]        2        1     2850   2194.7 
; [ 7,]        2        2     4000   4385.4 
; [ 8,]        2        3     4000   4104.8 
; [ 9,]        2        4     4200   4274.3 
; [10,]        2        5     5720   6889.7
; ---------------------------------------------------------------------
; Author      Joerg Breitung 990316
; ---------------------------------------------------------------------
  NT=rows(z)
  k=cols(z)   
  
  if (exist(T)) 
    N=NT/T
    error(N-floor(N)>0,"  The data set is not balanced (NT/N is not an integer)")
    error(T<2,         "  T must be at least 2")
    if (T>0) 
      ind=(1:N)  
      ind=kron(ind,matrix(T,1))
      time=(1:T)
      time=kron(matrix(N,1),time)
      z=ind~time~z
      k=k+2
    endif  
  endif 
  
  z[,2]=z[,2]+z[,1]./(z[NT,1]+1)
  mz=z[,3:k]
  z=sort(z,2)
  z[,2]=floor(z[,2])

  pos=1
  while(pos < NT-2)
    year=z[pos,2]
    zi=z[pos,]
    pos=pos+1
    while (z[pos,2]==year)
      zi=zi|z[pos,]
      pos=pos+1
    endo
    z[pos-rows(zi):pos-1,3:k]=zi[,3:k]-mean(zi[,3:k])
  endo 
  z[,1]=z[,1]+z[,2]./(z[NT,2]+1)
  y=sort(z,1)
  y[,1]=floor(y[,1])
  y[,3:k]=y[,3:k]+mz

  if (exist(T)) 
     y=y[,3:k]+mz
  endif
endp

