proc(hbeta,hg)=plmls(x,t,y,m,knots)
; -----------------------------------------------------------------
;    Library  plm	
; -----------------------------------------------------------------
;    See_also plmk,plmp
; -----------------------------------------------------------------
;    Macro	plmls
; -----------------------------------------------------------------
;    Description   plmls estimates partially linear models by using 
;                  least squares spline to approximate the nonparametric 
;		   part.
; -----------------------------------------------------------------
;    Usage    res = plmls(x,t,y,m,knots)
;    Input
;      Parameter  x
;      Definition   n x p matrix, the design points
;      Parameter  t
;      Definition   n  x 1 matrix, the design ponits
;      Parameter  y
;      Definition   n x 1 matrix, the response variables
;      Parameter  m
;      Definition   the order of spline
;      Parameter  knots
;      Definition  k x 1 matrix, knot sequence knots 
;    Output
;      Parameter  res.hbeta
;      Definition   p x 1 matrix, the estimate of the parameter
;      Parameter  res.hg
;      Definition   n x 1 matrix, the estimate of the nonparametric part
; -----------------------------------------------------------------
;  Example library("plm")
;          proc()=main()
;          n = 100
;          m=2
;	   sig=0*matrix(3,3)
;	   sig[,1]=#(0.81,0.1,0.2)
;	   sig[,2]=#(0.1,2.25,0.1)
;	   sig[,3]=#(0.2,0.1,1)
;	   x =normal(n,3)*sig
;	   t =sort(uniform(n))
;          beta0=#(1.2, 1.3, 1.4)
;	   y =x*beta0+t^3+0.01*normal(n)
;           kk=floor(rows(t)/2)
;          knots=0*(1:kk)
;	    j=1
;             while(j<=kk)
;               knots[j]=t[2*j]
;             j=j+1
;            endo
;         res=plmls(x,t,y,m,knots)
;         ddls=createdisplay(1,1)
;          datah1=t~t^3
;          datah2=t~res.hg
;          part=grid(1,1,rows(t))'
;          setmaskp(datah1,1,0,1)
;          setmaskp(datah2,4,0,3)
;          setmaskl(datah1,part,1,1,1)
;          setmaskl(datah2,part,4,1,3)
;          show(ddls,1,1,datah1,datah2)
;          setgopt(ddls,1,1,"xlabel","T","title","Simulation comparison","ylabel","g(T) and its estimate values")
;endp
;main()	   
; -----------------------------------------------------------------
;    Result   The parameter estimates, 3 x 1 matrix and nonparametric 
;             fitting are presented.
; -----------------------------------------------------------------
;   Author    Hua Liang, 98
; -----------------------------------------------------------------
k=rows(knots)
n=rows(t)
Z=0*matrix(n,m+k)
 i=1
 while(i<=m)
   Z[,i]=t.^(m-1)
   i=i+1
endo
 i=m+1
 while(i<=m+k)
   ss=(t-knots[i-m]).^(m-1)
   Z[,i]=max(ss~0*matrix(n,1),2)
  i=i+1
 endo 
S=0.001*diag(matrix(k+m))
P=Z*inv(Z'*Z+S)*Z'
I=diag(matrix(n))
hbeta=inv(x'*(I-P)*x)*x'*(I-P)*y
hg=P*(y-x*hbeta)
endp
