proc()=plotdot(inX, inColorScheme, inFactor)
; ---------------------------------------------------------------------
; Library     plot
; ---------------------------------------------------------------------
; See_also    plotbox, dispdot
; ---------------------------------------------------------------------
; Macro       plotdot
; ---------------------------------------------------------------------
; Description High level routine for dotplots.
; ---------------------------------------------------------------------
; Usage       plotdot(inX,inColorScheme {,inFactor})
; Input       
; Parameter   inX
; Definition  n x 1 Vector (continuous data)
; Parameter   inColorScheme
; Definition  m x 3 Vector of rgb colors for tonal highlighting
; Parameter   inFactor
; Definition  n x 1 Vector (discrete) specifying groups within inX
; Output      
; ---------------------------------------------------------------------
; Notes        Displays up to 250 dashes representing the data. If some
;              dashes overlap, another color from inColorScheme is used.
;              The more dashes, the higher the index of the color. This
;              is called "tonal highlighting".
;
;              The colors are linearly assigned to the frequencies of 
;              overlappings.
;              If the maximal frequency of overlappings is less than
;              the number of colors provided, only this smaller number
;              of colors is used.
;
;              Obviously, if inColorScheme is of lenght one, tonal 
;              highlighting is off.
;
;              The output of grcolorscheme() is a valid input for 
;              inColorScheme.
;
;              Requires the library "stats"
; ---------------------------------------------------------------------
; Example      library("graphic")
;              library("plot")
;              library("stats")
;              x = normal(4000)
;              theFactor = string("one", 1:1000) | string("two", 1:1000)
;              theFactor = theFactor | string("three", 1:1000) | string("four", 1:1000)
;              plotdot(x, grcolorscheme("topographic"), theFactor)
; ---------------------------------------------------------------------
; Result       Four dotplots in one display.
; ---------------------------------------------------------------------
; Keywords     high level graphics, dotplot, tonal highlighting, color scheme
; ---------------------------------------------------------------------
; Author      Stephan R. W. Lauer, 990302
; ---------------------------------------------------------------------

// The main task here is to generate the labels for the different groups.
// All other work is done within dispdot.

   if (exist("inFactor") <> 1 && exist("inFactor") <> 2)   // not numeric, not text
      dp = dispdot(inX, inColorScheme)
      dotplot = createdisplay(1, 1)  // it would be possible to create the
                                     // display *before* this 'if' and use
                                     // it in both branches, but this way
                                     // it is created 'just in time' :-)
      show(dotplot, 1, 1, dp)
   else 
      // create labels for the groups
 
      theGroups = discrete(inFactor)
      theNumberOfGroups = rows(theGroups)

      // locate the labels centered under the plots, vertical distance
      // is 15% of the spread of the data

      theY = min(inX) - 0.10 .* (max(inX) - min(inX))
      theY2 = min(inX) - 0.15 .* (max(inX) - min(inX))

      // let's see if the factor given is numeric or a string variable
      isNumeric = (exist(inFactor) == 1)
      

      // some inits
      theLabels = ( 0 ~ theY ) | ( 0 ~ theY2) // do this to ensure that the text labels
                                              // at the bottom are displayed properly
      theStrings = "Hallo" | "Hallo" // dummy string - empty string crashes
      theStringLocations = -1 | -1 // don't show dummy string
      count = 1
      if (isNumeric)
           while (count <= theNumberOfGroups)
                 theLabels = theLabels | ( (count - 1) * 1.5 + 0.5 ~ theY)
                 theStrings = theStrings | string("%1.0f", theGroups[count])
                 theStringLocations = theStringLocations | 0 // centered
           count = count + 1
           endo
      else
           while (count <= theNumberOfGroups)
                 theLabels = theLabels | ( (count - 1) * 1.5 + 0.5 ~ theY)
                 theStrings = theStrings | theGroups[count]
                 theStringLocations = theStringLocations | 0 // centered
           count = count + 1
           endo
      endif // isNumeric

      // now attach the strings to the points
      setmaskt(theLabels, theStrings, 0, theStringLocations, 16) // black, ..., size 16
      // hide points
      setmaskp(theLabels, 0, 0, 8)

      // now create the dotplot itself and show the results

      dp = dispdot(inX, inColorScheme, inFactor)
      dotplot = createdisplay(1, 1)
      show(dotplot, 1, 1, dp, theLabels)
   endif

 
 
endp