proc (q) = quantile (x, a)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      sort fivenum
; -----------------------------------------------------------------
;  Keywords      quantile, median
; -----------------------------------------------------------------
;   Macro        quantile
; -----------------------------------------------------------------
;   Description  Computes the empirical quantiles of a given array.
; -----------------------------------------------------------------
;   Usage        s = quantile (x, a)
;   Input
;     Parameter  x  
;     Definition array
;     Parameter  a 
;     Definition level for the quantiles (has to be in [0,1])
;   Output
;     Parameter  s  
;     Definition for each column in x the empirical quantiles
; -----------------------------------------------------------------
;   Notes        The empirical quantiles  are defined as the lowest 
;                observation y which fulfills #(x_i <= y) / n >= a.
; -----------------------------------------------------------------
;   Example   library("xplore")
;             randomize (0)
;             x = normal (200, 2, 2)
;             quantile (x, #(0, 0.5, 1))
; -----------------------------------------------------------------
;   Result
;             Contents of q
;             [,,1,1,1,1,1,1]
;             [1,] -2.7802 -3.0646 
;             [2,] -0.064325 -0.041017 
;             [3,] 2.4442 2.5595 
;             [,,2,1,1,1,1,1]
;             [1,] -2.7564 -2.7252 
;             [2,] 0.051381 0.18606 
;             [3,] 1.9993 4.2496 
; -----------------------------------------------------------------
;   Author    TTK, 960207
; -----------------------------------------------------------------
  error (min(a) < 0 || max(a) > 1, "level outside of [0,1]")
  q = sort(x,0)[ceil (rows(x).*a) + (a==0)]

endp
