proc(data)=recodeista(datain)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista istadata
; -----------------------------------------------------------------------
; Macro        recodeista
; -----------------------------------------------------------------------
; Description recodes the selected variables into binary variables with
;             with the most frequent value as the reference value.
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616, Sigbert Klinke 981027
;------------------------------------------------------------------------
  data=datain
  datah=data.x
  stringh = data.colname
  colth   = data.coltype
  colvh   = data.colvar  
  colmh   = data.colmissing
  selhead="Recode variables"
  selitem=data.colname
  sel=selectitemlist(selhead,selitem,15)
  if(sum(sel)>0)
    ;datah=(paf(data.x', sel))'
    i = 0
    while (i.<rows(sel))
      i = i+1
      if(sel[i])
        {g,gind}=groupcol(datah[,i],rows(datah[,i]))
         xn=(datah[,i]==g') 
         m=maxind(sum(xn)')==(1:rows(g))
         ;vector of ones for referencevalue
         g1=paf(g,(1-m))
         g1=string("== %g ",g1)
         ;new variablenames
         r=string("referencegroup %g    ",paf(g,m))
         r
         ;referencevalue in output window
         xn=(paf(xn',(1-m)))' 
         ;do not recode referencevalue
         data.x=data.x~xn
         ;add new variables to data.x
         selhead1="Exclude original variable"
         selitem1="Yes"|"No"
         sel1=selectitem(selhead1,selitem1,"single")
         if(sel1[1])
           colvh[i]=0 ;exclude variable  
         endif
         if(sel1[2])
           sel[i]=0
         endif
         k=0
         while(k<cols(xn))
           k=k+1
           stringh=stringh|data.colname[i]+g1[k]
           ;new name according Xi==value[g1]
           colth=colth|1 ;new variable not continuous
           colvh=colvh|1 ;new variable not deleted
           colmh=colmh|1 ;new variable not deleted
           sel=sel|0
         endo
       endif 
     endo  
   endif 
   data.colname=stringh
   data.coltype=colth   
   data.colvar=  colvh   
   data.colmissing =colmh 
endp
