proc(red,redm)=redun(b,sk,lk,skl,y)
;-------------------------------------------------------------------
;    Library      metrics
;-------------------------------------------------------------------
;    See_also     glm, dpls, makedesign
;-------------------------------------------------------------------
;    Macro        redun
;-------------------------------------------------------------------
;    Description  calculating single redundance and redundance vector
;                 for dpls macro as measure for goodness
;-------------------------------------------------------------------
;    Usage       {red,redm}=redun(b,sk,lk,skl,y)
;    Input
;      Parameter  b
;      Definition     a matrix with loadings
;      Parameter  sk
;      Definition     a matrix with path coefficients
;      Parameter  lk
;      Definition     a matrix with latent variables
;      Parameter  skl
;      Definition     a matrix with lagged path coefficients
;      Parameter  y
;      Definition     a matrix with manifest variables (indicators)
;    Output
;      Parameter  red
;      Definition     a scalar with single redundance value
;      Parameter  redm
;      Definition     a vector with redundace values
;-------------------------------------------------------------------
;   Example  library("metrics")
;            randomize(13409)
;            b1=0.3
;            c1=0.6
;            s=500
;            n1=normal(s+1)
;            n1lag=n1[1:s,]
;            n1=n1[2:rows(n1),]
;            n2=b1*n1+c1*n1lag+normal(rows(n1))/5
;            n=n1 ~ n2
;            nn=n./sqrt(var(n))
;            p=( 1 | 2 | 3 | 4 | 0 | 0 | 0) ~ (0 | 0 | 0| 0 | 5 | 6 | 7)
;            y=nn*p'+normal(rows(n),rows(p))/8
;            d=(0 | 1) ~ (0 | 0)
;            dl=(0 | 1) ~ (0 | 0)
;            w=(1 | 1 | 1 | 1 | 0 | 0 | 0) ~ (0 | 0 | 0 | 0 | 1 | 1 | 1 )
;            {wg,b,sk,skl,lk,iter}=dpls(w,d,w,dl,y,3)
;            {red,redm}=redun(b,sk,lk,skl,y)
;            sk 
;            skl 
;            b 
;            red
; -----------------------------------------------------------------
;   Result    
;  Contents of sk
;
;  [1,]        0        0 
;  [2,]    0.423        0 
;
;  Contents of skl
;  
;  [1,]        0        0 
;  [2,]    0.856        0 
;
;  Contents of b
;
;  [1,]   0.9967        0 
;  [2,]   2.0131        0 
;  [3,]    3.005        0 
;  [4,]   4.0134        0 
;  [5,]        0   5.0093 
;  [6,]        0   5.9997 
;  [7,]        0   6.9937 
;
;  Contents of red
;
;  [1,]  0.90498 
; -----------------------------------------------------------------
;   Author    Prof.Dr.H.G.Strohe Universitaet Potsdam; 
;             programmed by cand rer oec Frank Geppert; 
;             See for details: "DPLS Algorithmus und Computerprogramm
;             fuer dynamische Partial-Least-Squares-Modelle"
; -----------------------------------------------------------------
t=lk'
vsk=sk
dl=skl
y=y'
ty=dim(t)
ty=ty[1,1]                                      ; Anzahl Bloecke
m=dim(y)
my=m[1,1]                                       ; Anzahl Manifest.
m=m[2,1]-2                                      ; Anzahl Beobachtg
tn=t[,(2:(m+1))]                                ; Reihe ohne Lag
tl=t[,(1:m)]                                    ; Reihe mit Lag
c=corr(tn')                                     ; Korrelation
ttl=(tn') ~ (tl')                               ; glue /axis=2
ac=corr(ttl)
ac=ac[(1:ty),(ty+1):rows(ac)]                   ; Autokorrelation
cy=(sqrt(var(y'))^2)'                           ; Varianz von Y
pb=b*vsk
pc=b*dl
pbrpb=pb*(c*pb')
pbapc=pb*(ac*pc')
dim(pc) dim(c) dim(pc')
pcrpc=pc*(c*pc')
gs=pbrpb+pbapc+pbapc'+pcrpc
i=0
dg=matrix(rows(gs))
do
 i=i+1
 dg[i]=gs[i,i]
until (i==rows(gs))                              ;mt_diag gs > dg
g2=dg/cy
numb=0
i=0
do
 i=i+1
 j=0
 do
  j=j+1
  if (g2[i,j] != 0)
   numb=numb+1
  endif
 until (j==cols(g2))
until (i==rows(g2))                             ;gs2=sum(g2)/sum(sign(g2))
gs2=sum(g2)/numb
red=gs2
redm=g2
endp