proc(rel)=relationrank(x, colname, opt)
; -----------------------------------------------------------------------
; Library      stats
; -----------------------------------------------------------------------
; See_also     relation relationchi2 relationcont relationcorrcont
;              relationcorr
; -----------------------------------------------------------------------
; Macro        relationrank
; -----------------------------------------------------------------------
; Description  Computes the rank correlation of spearman for ordinal
;              data.
; ----------------------------------------------------------------------
;   Notes      To compute the rank correlation coefficient 
;              non-interactively you need to set opt = "automatic". 
;              In the interactive mode
;              you will get a menu sorted after the largest coefficients.
;              If you click on the coefficient you will get a plot 
;              of the corresponding variables.
;
; -----------------------------------------------------------------------
; Usage        rel = relationrank (x {, colname {, opt}})
; Input
;   Parameter  x 
;   Definition n x p      variables
;   Parameter  colname
;   Definition p x 1      text vector of names of x variables
;   Parameter  opt 
;   Definition q x 1      text vector of optional parameters
; Output
;   Parameter  rel.r      
;   Definition p x p      matrix of rank correlation  coefficients
;   Parameter  rel.pval   
;   Definition p x p      unused (filled with NaNs)
; -----------------------------------------------------------------------
; Example      ; loads the library stats
;              library("stats")   
;              ; read swiss banknote data
;              x = read ("bank2")
;              ; compute the rank correlation coefficients
;              colname = string ("X%0.f", 1:cols(x))
;              rel = relationrank (x, colname, "automatic")
;              rel.r
; -----------------------------------------------------------------------
; Result  Contents of r;
;         [1,]        1   0.2256  0.10803 -0.18962 -0.050143  0.22878 
;         [2,]   0.2256        1  0.75063  0.42721  0.36966 -0.48552 
;         [3,]  0.10803  0.75063        1  0.52009  0.42863 -0.50498 
;         [4,] -0.18962  0.42721  0.52009        1  0.16893 -0.60763 
;         [5,] -0.050143  0.36966  0.42863  0.16893        1 -0.58344 
;         [6,]  0.22878 -0.48552 -0.50498 -0.60763 -0.58344        1 
; -----------------------------------------------------------------------
; Author       Sigbert Klinke 970820
; ----------------------------------------------------------------------

  colnamegiven = (exist("colname")==2) 
  if (colnamegiven)
    colnamegiven = (rows(colname)==cols(x))
  endif
  if (!colnamegiven)
    colname = string ("X%.0f", 1:cols(x))
  endif

  p = cols(x)
  r = rank(x[,1])
  i = 1
  while (i<p)
    i = i+1
    r = r~rank(x[,i])
  endo
  r = corr(r)
  pval = NaN.*matrix(p,p)
  optgiven  = (exist("opt")==2)
  automatic = 0
  if (optgiven)
    automatic = sum(opt=="automatic")
  endif
  if (automatic==0)
    vr = vec(r)~grid(#(1,1), #(1,1), #(p,p))
    vr = sort(abs(vr[,1])~vr, -1)
    vr = vr[p+1:rows(vr)]
    vr = paf(vr, (1:rows(vr))%2)
    selhead = "Rank (Spearmen)"
    vrp = 0
    sel = 1
    while (sum(sel))
      if (vrp==0)
        if (rows(vr)>15) 
          selitem = string ("%7.3f", vr[1:15,2])|"Next"
          selop   = (1:15)|-1
        else
          selitem = string ("%7.3f", vr[1:rows(vr),2])
          selop   = 1:rows(vr)
        endif
      else
        if ((vrp*15+15)<rows(vr))
          selitem = string ("%7.3f", vr[vrp*15+1:vrp*15+15,2])|"Back"|"Next"
          selop   = (vrp*15+1:vrp*15+15)|-2|-1
        else
          selitem = string ("%7.3f", vr[vrp*15+1:rows(vr),2])|"Back"
          selop   = (vrp*15+1:rows(vr))|-2
        endif
      endif
      sel = selectitem(selhead, selitem, "single")
      if (sum(sel))
        ii = paf (1:rows(sel), sel)
        i  = selop[ii]
        if (i==-1)
          if (vrp*15+16<rows(vr))
            vrp = vrp+1
          endif
        endif
        if (i==-2)
          if (vrp)
            vrp = vrp-1
          endif
        endif
        if (i>0)
          relationdisp = createdisplay(1, 1)
          show (relationdisp, 1, 1, x[,vr[i,3]]~x[,vr[i,4]])
          rdt = string ("%s-%s", colname[vr[i,3]], colname[vr[i,4]]) + selitem[ii] 
          setgopt (relationdisp, 1, 1, "title", rdt)
        endif
      endif
    endo
  endif  
  rel = list (r, pval)
endp
