proc(data)=relations(datain)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista istastatistic  relation tabular
; -----------------------------------------------------------------------
; Macro        relations
; -----------------------------------------------------------------------
; Description  Computes the relation coefficients (chi^2,contingency, 
;              corrected contingency, spearman rank, bravais-pearson) for 
;              selected variables. It is possible to compute the 
;              coefficients interactively or non-interactively.
;              In the interactive mode you have to choose one of the 
;              coefficients. Then you will get a menu sorted after the 
;              largest coefficients. If you click on the coefficient
;              you will get some more information to the corresponding 
;              variables. 
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords       
;------------------------------------------------------------------------
; Author       Sigbert Klinke 970820  Kerstin Zanter 980616
;------------------------------------------------------------------------
  data=datain
  datah=paf(data.x, data.rowcase&&data.randcase&&data.rowmissing)
  text="Correlation"
  sel1=choosevariable2(data,text)
  if(sum(sel1))
    datah=paf(datah',sel1)'
    colname=paf(data.colname, sel1)
    selhead="Compute coefficients interactively?"
    selitem="Yes"|"No"
    do
      sel=selectitem(selhead,selitem,"single")
      if(sel[1])
        rel = relation (datah, colname) 
      endif
      if(sel[2])
        selhead2="Coefficient" 
        selitem2="Chi^2"|"Contingency"|"Corr. Contingency"
        selitem2=selitem2|"Rank"|"Bravais-Pearson"
        do
          sel2=selectitem(selhead2,selitem2,"single")
          if(sel2[1])
            {r,pval} = relation (datah,colname, "automatic"|"Chi^2") 
            header="Chi^2 coefficients"
            tabular=tabular(r,colname,header)
            tabular
            header="Chi^2 p-values"
            tabular=tabular(pval,colname,header)
            tabular
          endif
          if(sel2[2])
           {r,pval}  = relation (datah, colname, "automatic"|"Contingency") 
            header="Contingency coefficients"
            tabular=tabular(r,colname,header)
            tabular
            header="Chi^2 p-values"
            tabular=tabular(pval,colname,header)
            tabular
          endif
          if(sel2[3])
            {r,pval}= relation (datah, colname, "automatic"|"Corr. Contingency")
            header="Corrected contingency coefficients"
            tabular=tabular(r,colname,header)
            tabular
            header="Chi^2 p-values"
            tabular=tabular(pval,colname,header)
            tabular
          endif
          if(sel2[4])
            {r,pval} = relation (datah, colname, "automatic"|"Rank")
            header="Rank correlation coefficients"
            tabular=tabular(r,colname,header)
            tabular
          endif
          if(sel2[5])
            {r,pval}= relation (datah, colname, "automatic")
            header="Bravais-Pearson correlation coefficients"
            tabular=tabular(r,colname,header)
            tabular
            header="T-test values"
            tabular=tabular(pval,colname,header)
            tabular
          endif
        until(sum(sel2).=0)
      endif  
    until(sum(sel).=0)
  endif
endp
