proc(u)=residuen(coeff,ord,di,adj,tb,te,ytt)
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  coeffest
; ----------------------------------------------------------------------
;   Macro	  residuen
; ----------------------------------------------------------------------
;   Description   calculates residuals for VAR models
; ----------------------------------------------------------------------
;   Usage         u = residuen(coeff,ord,di,adj,tb,te,ytt)
;   Input 
;     Parameter   coeff 
;     Definition     matrix, the coefficients 
;     Parameter   ord 
;     Definition     integer, order of series 
;     Parameter   di 
;     Definition     integer, dimension of time series
;     Parameter   adj 
;     Definition     scalar, 1=if adjusted, 0=if not
;     Parameter   tb 
;     Definition     integer, (time) begin
;     Parameter   te 
;     Definition     integer, (time) end 
;     Parameter   ytt 
;     Definition     vector, the transformed time series
;   Output
;     Parameter   u
;     Definition     matrix, estimated residuals     
; ----------------------------------------------------------------------
;   Author        Hafner, Sperlich 971212
; ---------------------------------------------------------------------- 
   if (ord .>0)
      mw=adj*mean(ytt[,tb:te]')'
      a=tb
      b=min(te|90+tb)
      u=ytt[,a:b]-coeff*zxgen(ytt-mw,a-1,b-1,ord,adj)-mw;
      while (b != te) 
         a=b+1;
         b=min(te|b+90)
         u=u~ytt[,a:b]-coeff*zxgen(ytt-mw,a-1,b-1,ord,adj)-mw
      endo
   else
      u=ytt[,tb:te]-mean(ytt[,tb:te]')'
   endif
endp
