proc(y)=rev(x)
; -----------------------------------------------------------------
;   Library       multi
; -----------------------------------------------------------------
;   See_also      sort
; -----------------------------------------------------------------
;   Macro         rev
; -----------------------------------------------------------------
;   Description   reverts the order of the rows of the input matrix
; -----------------------------------------------------------------
;   Usage         y = rev(x)
;   Input
;     Parameter   x
;     Definition      n x d matrix 
;   Output
;     Parameter   y
;     Definition      n x d matrix, x reverted 
; -----------------------------------------------------------------
;   Example   library("multi")
;             randomize(0)
;             x = normal(5,2)
;             y = rev(x)
;             x
;             y
; -----------------------------------------------------------------
;   Result    Contents of x
;             [1,] -0.21293  0.69812 
;             [2,]  -1.0078 -0.38946  
;             [3,]   1.9502  -1.5746  
;             [4,]  -1.3052 -0.26595 
;             [5,]  -1.4341  0.19947
;             Contents of y
;             [1,]  -1.4341  0.19947
;             [2,]  -1.3052 -0.26595 
;             [3,]   1.9502  -1.5746 
;             [4,]  -1.0078 -0.38946 
;             [5,] -0.21293  0.69812 
; -----------------------------------------------------------------
;   Author    Christian Hafner, Sperlich  971027
; -----------------------------------------------------------------
  ind = 1:rows(x)
  y = sort(ind~x,-1)
  y = y[,2:cols(y)] 
endp
