
proc (y) = rtrian(x)

; -----------------------------------------------------------------
; Library       kernel
; -----------------------------------------------------------------
;  See_also     repa rqua rtri runi genvub
; -----------------------------------------------------------------
;   Macro       rtrian
; -----------------------------------------------------------------
;   Description  rtrian computes the multivariate radial symmetric
;                triangle kernel
;                                       
; -----------------------------------------------------------------
;   Usage        y = rtrian(x)
;   Input
;     Parameter  x  
;     Definition  n x p matrix
;   Output
;     Parameter  y  
;     Definition  n x 1 matrix
; -----------------------------------------------------------------
;   Example   library("kernel") 
;             x = aseq(-1, 21, 0.1) 
;             y = rtrian(x) 
;             t=createdisplay(1,1)                                      
;             show(t,1,1,x~y)                                    
; -----------------------------------------------------------------
;   Result    The kernel is pictured  
; -----------------------------------------------------------------
;   Author   Sigbert Klinke, Lijian Yang, 951117   
; -----------------------------------------------------------------

  d  = cols(x)  
  error (d.>15, "rtrian : Dimension too large (>15)")
  wd = getglobal("vub")[d]
  r  = sum(x^2,2)
  y  = d.*(d+1)./wd.*(1-sqrt(r)).*(r.<1) 
endp 
;***********************************************************************       
