proc (v, wo, s) = runsa(disp, w, u, m, x, y, t, errfun, dec, res, fs, weidist, vmeth)
; -----------------------------------------------------------------------
; Library      nn
; -----------------------------------------------------------------------
; See_also     ann
; -----------------------------------------------------------------------
; Macro        runsa
; -----------------------------------------------------------------------
; Description  optimizes a neural network by Boltzman annealing
; -----------------------------------------------------------------------
; Author      Sigbert Klinke, Janet Grassmann,  951231; Sigbert Klinke, 961121
; -----------------------------------------------------------------------
  wo = w
  {xt, yt, xe, ye, we, s, yep, ybp, v, ve} = runinit(x, y, t, errfun, w, u, dec, m, vmeth)
  i = 1               
  while (res)               
    t  = eh               
    k  = 0.1               
    while (k.>0.01)               
      wb = wo[,1:2]~(wo[,3]+k.*normal(rows(wo)))               
      yb = nnfunc(wb, u, xt)               
      s[1,1] = _errfun(yt, yb, wb[,3], dec)               
      if (1./(1+exp((s[1,1]-s[1,2])/k)).>uniform(1))               
        {wo, s, v, we, ybp, yep, ve}=runshow(disp, wb, u, s, m, v, ybp, yep, xt, xe, we, dec, ve, i, ye, res, weidist, errfun, vmeth)         
      endif               
      i = i+1               
      t = t+1               
      k = 1./log(t)               
    endo               
    ;check               
    res = res-1               
  endo               
  wo = wb~we[,3]               
  s = s[,2]               
  if (fs)               
    finalshow (disp, wo, u, s, ybp, yep, xt, xe, dec, v, ve, m, weidist, vmeth)
  endif               
endp               
