proc(no)=select1item(stitle,sitems,atitle)
; ----------------------------------------------------------------------------
; Library       glm
; ----------------------------------------------------------------------------
;  See_also     glmfit doglm
; ----------------------------------------------------------------------------
;   Macro       select1item
; ----------------------------------------------------------------------------
;   Description  select1item is an item selector for glm. It allows exactly 
;                one item to be selected.
; ----------------------------------------------------------------------------
;   Usage        no=select1item(stitle,sitems,atitle)
;   Input
;     Parameter   stitle
;     Definition        string, menu title.
;     Parameter   sitems
;     Definition        string vector, menu items.
;     Parameter   atitle
;     Definition        optional, an alternative menu title if an error
;                       (no selection or more than 1 selection) occurred.
;   Output
;     Parameter   no
;     Definition        number of selected item.
; ----------------------------------------------------------------------------
;   Example   library("glm") 
;             stitle="make your choice"
;             sitems="1"|"2"|"3"
;             atitle="make ONE choice"
;             no=select1item(stitle,sitems,atitle)
;             no
; ----------------------------------------------------------------------------
;   Result    Your chosen number.
; ----------------------------------------------------------------------------
;   Author    Marlene Mueller, 2000/05/18
; ----------------------------------------------------------------------------
;
    if (exist(atitle)==0)
      atitle=stitle
    endif
;
    numsel=0
    while (sum(numsel)<1)
      numsel=selectitem(stitle,sitems)
      if (sum(numsel)!=1)
        numsel=selectitem(atitle,sitems)
        while (sum(numsel)!=1)
          numsel=selectitem(atitle,sitems)
        endo
      endif
    endo
;
    no=numsel.*(1:rows(numsel))
    no=paf(no,no.>0)
endp










