proc(d3sls,cov3,d2sls)=seq(seqlist1,seqlist2)
; ---------------------------------------------------------------------
; Library     metrics
; ---------------------------------------------------------------------
; See_also    gls
; ---------------------------------------------------------------------
; Macro       seq
; ---------------------------------------------------------------------
; Description Estimates a simultaneous equations model by 3-stage least squares 
; ---------------------------------------------------------------------
; Usage       {d3sls,cov3,d2sls} = seq(seqlist1,seqlist2)
; 	Input        
; 	Parameter	seqlist1
; 	Definition	list of matrices. If there are M equations then seqlist1
;			will be a list of M+2 matrices.  The first matrix is comprised of 
;			the vectors of observations of the left-hand side variables. The
;			next M matrices consist of the observations of the right-hand-side 
;			variables of the M equations. The last matrix contains the observations 
;			of the exogenous variables of the system.
; 	Parameter	seqlist2
; 	Definition	list of string vectors. If there are M equations then seqlist2
;			will be a list of M+2 string (column) vectors. Each vector contains 
;			the names of the variables of the corresponding matrix from seqlist1.
; Output      
; Parameter   d3sls   
; Definition  3-stage lest squares coefficient estimates 
; Definition          vector
; Parameter   cov3       
; Definition  estimated covariance matrix of the 3sls-estimator 
; Definition          matrix
; Parameter   d2sls   
; Definition  2-stage lest squares coefficient estimates 
; Definition          vector
; ---------------------------------------------------------------------
; Notes       Greene (1996) or any other good econometrics textbook
; ---------------------------------------------------------------------
; Example     
; ; simulated data for a supply-and-demand model
; n=50
; randomize (101)
; sp      = #(1,-0.7)~#(-0.7,1)             	; covariance matrix
; mp      = #(4,4)                          	; mean vector
; pcompete = qfc(2*matrix(n,1),uniform(n))  	; price of competitor         
; income  = qfc(3*matrix(n,1),uniform(n)) 
; praw    = qfc(matrix(n,1),uniform(n))    	; price of inputs
; one     = matrix(n,1)
			
; randomize(102)
; u2=uniform(n)				; uniform random numbers used for error term							
; n2=1.2*qfn(u2)
; randomize(103)
; u3=uniform(n)					
; n3=1.2*qfn(u3)
; ; price and quantity computed as solutions of 2-equation system
; price=1/1.5*(34+.25*pcompete+0.5*income+0.75*praw+-0.8*qfn(u3))
 
; q=40-price+.25*pcompete[,2]+0.5*income+n2
; /* structural equations */
; ;qd=40-price+.25*pcompete+0.5*income+n2
; ;qs=6+0.5*price-.75*praw+n3
; ; setting up the matrices for seqlist1
; lhs=q~q
; z1=one~price~pcompete~income
; z2=one~price~praw
; x=one~pcompete~income~praw
; seqlist1=list(lhs,z1,z2,x)
; ; setting up the string vectors for seqlist2
; yl="quantity demanded"|"quantity supplied"
; zl1="one"|"price"|"pcompete"|"income"
; zl2="one"|"price"|"praw"
; xl="one"|"pcompete"|"income"|"praw"
; seqlist2=list(yl,zl1,zl2,xl)
; {d3,s,d2}=seq(seqlist1,seqlist2)
; d3~d2
; ---------------------------------------------------------------------
; Result  You will find the following output in the output window    
;
; Contents of output2sls
;
; [ 1,] "====================================================="
; [ 2,] "2stage Least-squares estimates"
; [ 3,] "====================================================="
; [ 4,] " EQ	dep. var.		R2	"
; [ 5,] "====================================================="
; [ 6,] " 1	quantity               0.244     "
; [ 7,] " 2	quantity               -0.068     "
; [ 8,] "====================================================="
; [ 9,] "VARIABLE    Coef.Est.        Std.Err.          t"
; [10,] "--------------------------------------------------"
; [11,] "one           28.296          6.727         28.296"
; [12,] "price         -0.495          0.291         -0.495"
; [13,] "pcomp          0.113          0.112          0.113"
; [14,] "incom          0.345          0.139          0.345"
; [15,] "--------------------------------------------------------
; [16,] "one            7.513          6.412          7.513"
; [17,] "price          0.421          0.267          0.421"
; [18,] "praw          -0.364          0.172         -0.364"
; [19,] "====================================================="
;
; Contents of output3sls
;
; [ 1,] "====================================================="
; [ 2,] "   3stage Least-squares estimates"
; [ 3,] "====================================================="
; [ 4,] " EQ	dep. var.		R2	"
; [ 5,] "====================================================="
; [ 6,] " 1	quantity               0.244     "
; [ 7,] " 2	quantity               -0.068     "
; [ 8,] "====================================================="
; [ 9,] "VARIABLE    Coef.Est.        Std.Err.          t"
; [10,] "--------------------------------------------------"
; [11,] "one           28.365          6.439          4.405"
; [12,] "price         -0.498          0.278         -1.791"
; [13,] "pcomp          0.128          0.059          2.175"
; [14,] "incom          0.341          0.132          2.589"
; [15,] "-------------------------------------------------------
; [16,] "one            7.513          6.217          1.209"
; [17,] "price          0.421          0.258          1.630"
; [18,] "praw          -0.364          0.167         -2.176"
; [19,] "====================================================="
;
; Contents of _tmp
;
; [1,]   28.365   28.296 
; [2,] -0.49837 -0.49493 
; [3,]  0.12777  0.11271 
; [4,]  0.34135   0.3446 
; [5,]   7.5132   7.5132 
; [6,]  0.42127  0.42127 
; [7,] -0.36355 -0.36355 
;
; ---------------------------------------------------------------------
; Keywords    simultaneous equations
; ---------------------------------------------------------------------
; Author      aw (000217)
; ---------------------------------------------------------------------

; figuring out the number of equations

L=size(seqlist1)    ; number of items in the list
M=L-2               ; number of equations

; setting up the data

y=seqlist1{1}
z1=seqlist1{2}
zM=seqlist1{L-1}
x=seqlist1{L}
r1=rows(x)*(M-1)
zl=(x*inv(x'*x)*(x'*z1))|zeros(r1,cols(z1))
yl=vec(y)

; preparing matrix of instruments

	j=2 
	while (j<=M-1)
	r2=rows(x)*(j-1)
	r3=rows(x)*(M-j)
	zl=zl~(zeros(r2,cols(seqlist1{j+1}))|(x*inv(x'*x)*(x'*seqlist1{j+1}))|zeros(r3,cols(seqlist1{j+1})))
	j=j+1
	endo
zl=zl~(zeros(r1,cols(zM))|(x*inv(x'*x)*(x'*zM)))

; 2-stage least squares estimates

d2sls=inv(zl'*zl)*(zl'*yl)
; residuals and standard errors

e2=y[,1]-z1*d2sls[1:cols(z1),1]
rl=cols(z1)
zzi=inv((x*inv(x'*x)*(x'*seqlist1{2}))'*(x*inv(x'*x)*(x'*seqlist1{2})))
s2jj=(e2'*e2)/(rows(e2)-cols(seqlist1{2}))
se2=s2jj*((zzi.*unit(rows(zzi)))*matrix(rows(zzi)))

	k=2
	while (k<=M)
	rf=rl+1
	rl=rf-1+cols(seqlist1{k+1})
	ee2=(y[,k]-seqlist1{k+1}*d2sls[rf:rl,1])
	e2=e2|ee2
	s2jj=(ee2'*ee2)/(rows(ee2)-cols(seqlist1{k+1}))
	zzi=inv((x*inv(x'*x)*(x'*seqlist1{k+1}))'*(x*inv(x'*x)*(x'*seqlist1{k+1})))
	sejj=s2jj*((zzi.*unit(rows(zzi)))*matrix(rows(zzi)))
	se2=se2|sejj
	k=k+1
	endo
 
se2=sqrt(se2)
t2=d2sls./se2
t2=d2sls
; covariance matrix of residuals

e2=reshape(e2,#(rows(seqlist1{1}),M,1))
em2 = sum (e2) ./ rows(e2)                
sige2  = (e2'*e2 - rows(e2)*em2'*em2) ./ rows(e2)

; R-squared

sigy=(y'*y - rows(y)*mean(y)'*mean(y)) ./ rows(y)
R2=1-((sige2.*unit(rows(sige2)))*matrix(rows(sige2),1))./((sigy.*unit(rows(sigy)))*matrix(rows(sigy),1))

omega=kron(sige2,unit(rows(seqlist1{1})))

; output of 2-stage least squares estimation

fmt = "     %10.3f"
d2str = string (fmt, d2sls)
se2str = string (fmt, se2)
t2str = string (fmt, t2)
varstr =seqlist2{2}|seqlist2{3}|seqlist2{4}

	line1="2stage Least-squares estimates"
	line2="=====================================================" 
	line3=" EQ	dep. var.		R2	"
	line4="=====================================================" 
	
	eqtext=string("%2.0f	", 1:M)
	deptext=substr(seqlist2{1}+"          ",1,10)
	r2text=string("%0.3f",R2)
	header=eqtext+deptext+"              "+r2text+"     "


	line5="=====================================================" 
	line6="VARIABLE    Coef.Est.        Std.Err.          t"    
 
	thinline="--------------------------------------------------"

	nicetext=substr(seqlist2{2}+"     ",1,6)
	rs=rows(seqlist2{2})
	crs=rs
	paratext=d2str[1:rs,]
	setext=se2str[1:rs,]
	ttext=t2str[1:rs,]

	l=3
	while (l<=M+1)
	crso=crs
	rs=rows(seqlist2{l})	
	crs=crs+rs
	nicetext=nicetext|thinline|substr(seqlist2{l}+"     ",1,6)
	paratext=paratext|thinline|d2str[(crso+1):(crs),]
	setext=setext|thinline|se2str[(crso+1):(crs),]
	ttext=ttext|thinline|t2str[(crso+1):(crs),]
	l=l+1
	endo
	text=nicetext+paratext+setext+ttext
output2sls=line2|line1|line2|line3|line4|header|line5|line6|thinline|text|line2
output2sls 


; 3-stage least squares estimates

d3sls=gls(zl,yl,omega)
cov3=inv(zl'*kron(inv(sige2),unit(rows(seqlist1{1})))*zl)
se3=sqrt(cov3.*unit(rows(cov3)))*matrix(rows(cov3),1)
t3=d3sls./se3

; residuals and R2

e3=y[,1]-z1*d3sls[1:cols(z1),1]
rl=cols(z1)

	k=2
	while (k<=M)
	rf=rl+1
	rl=rf-1+cols(seqlist1{k+1})
	ee3=(y[,k]-seqlist1{k+1}*d3sls[rf:rl,1])
	e3=e3|ee3
	k=k+1
	endo

; covariance matrix of residuals

e3=reshape(e3,#(rows(seqlist1{1}),M,1))
em3 = sum (e3) ./ rows(e3)                
sige3  = (e3'*e3 - rows(e3)*em3'*em3) ./ rows(e3)

; R-squared

R2=1-((sige3.*unit(rows(sige3)))*matrix(rows(sige3),1))./((sigy.*unit(rows(sigy)))*matrix(rows(sigy),1))


; formatting output of 3sls-estimation
 
d3str = string (fmt, d3sls)
se3str = string (fmt, se3)
t3str = string (fmt, t3)

	line1="   3stage Least-squares estimates"
	line2="=====================================================" 
	line3=" EQ	dep. var.		R2	"
	line4="=====================================================" 
	
	eqtext=string("%2.0f	", 1:M)
	deptext=substr(seqlist2{1}+"          ",1,10)
	r2text=string("%0.3f",R2)
	header=eqtext+deptext+"              "+r2text+"     "


	line5="=====================================================" 
	line6="VARIABLE    Coef.Est.        Std.Err.          t"    
	exline="INSTRUMENTS     Mean        Std.Dev.          "    
	extext=substr(seqlist2{L}+"     ",1,6)
	minststr = string (fmt, mean(x)')
	sinststr = string (fmt, sqrt(var(x))')
	extext=extext+minststr+sinststr
	thinline="--------------------------------------------------"
	nicetext=substr(seqlist2{2}+"     ",1,6)

	rs=rows(seqlist2{2})
	crs=rs
	paratext=d3str[1:rs,]
	setext=se3str[1:rs,]
	ttext=t3str[1:rs,]

	l=3
	while (l<=M+1)
	crso=crs
	rs=rows(seqlist2{l})	
	crs=crs+rs
	nicetext=nicetext|thinline|substr(seqlist2{l}+"     ",1,6)
	paratext=paratext|thinline|d3str[(crso+1):crs,]
	setext=setext|thinline|se3str[(crso+1):crs,]
	ttext=ttext|thinline|t3str[(crso+1):crs,]
	l=l+1
	endo
	text=nicetext+paratext+setext+ttext

output3sls=line2|line1|line2|line3|line4|header|line5|line6|thinline|text|line2|exline|thinline|extext|line2
output3sls
endp
library("xplore")
