proc (bn1, bn2) = softauto (b1, b2, x)
; -----------------------------------------------------------------------
; Library      twave 
; -----------------------------------------------------------------------
; See_also     hardauto hardthres softthres
; -----------------------------------------------------------------------
; Link         ../tutorials/wavestart.html Wavelet tutorial
; -----------------------------------------------------------------------
; Macro        softauto
; -----------------------------------------------------------------------
; Description  Softthresholds the mother wavelet coefficients b1 and b2 
;              automatically by sqrt(2 sigma n). To compute the 
;              threshold value only b1 and x is used.
; -----------------------------------------------------------------------
; Usage        {bn1, bn2} = softauto (b1, b2, x)
; Input
;   Parameter  b1
;   Definition n x 3 array     of mother wavelet coefficient
;   Parameter  b2
;   Definition n x 3 array     of mother wavelet coefficient
;   Parameter  x
;   Definition m x 1 array     of data
; Output
;   Parameter  bn1
;   Definition n x 3 array     of thresholded mother wavelet coefficient
;   Parameter  bn2
;   Definition n x 3 array     of thresholded mother wavelet coefficient
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960912
; -----------------------------------------------------------------------
  n   = rows(x)
  ba  = max(b2[,1])
  bt  = paf(b2[,3], b2[,1].=ba)
  vn  = 2.*sum(bt^2)/n
  ht  = sqrt(2.*vn.*log(rows(b2)))
  bn1 = b1[,1:2]~((b1[,3]-ht).*(b1[,3].>ht)+(b1[,3]+ht).*(b1[,3].<-ht))   
  bn2 = b2[,1:2]~((b2[,3]-ht).*(b2[,3].>ht)+(b2[,3]+ht).*(b2[,3].<-ht))
endp
