proc(y)=ssr(tree,node)
;calls endpoint
; -----------------------------------------------------------------------
; Library      xclust
; -----------------------------------------------------------------------
; See_also     cartsplit, cartsplitopt, cartcv, leafnum, maketr,  pred,
;              prederr, prune, prunecv, pruneseq, prunetot, kuva
; -----------------------------------------------------------------------
; Macro        ssr
; -----------------------------------------------------------------------
; Description  Returns the sum of squared residuals in a
;              regression tree.
; -----------------------------------------------------------------------
; Usage         res = ssr(cs, node)
; Input        
;   Parameter  cs
;   Definition  list of vectors: data structure which represents a binary tree
;               and is produced by cartsplit procedure, contains vectors 
;               cs.val, cs.vec, cs.mean, cs.ssr, cs.nelem.
;               See cartsplit for the description of cs.
;   Parameter   node
;   Definition  integer >= 1: gives the index of the root node of
;               the subtree whose mean of squared residuals
;               will be calculated.
;               If node=1, the mean of squared residuals in the hole tree is
;               calculated, if node=2, the mean of squared residuals in the
;               left subtree is calculated, if node=3, the mean of squared 
;               residuals in the left subtree of the left subtree
;               (if it exists) is calculated. See cartsplit for
;               the explanation how the tree is represented as a
;               vector. 
; Output       
;   Parameter  res
;   Definition  real number >= 0: sum of squared residuals in the specified
;               subtree.
; -----------------------------------------------------------------------
; Notes      The sum of squared residuals is defined as
;            the sum of squared differences between 
;            the observed  
;            values of the response variable and
;            the predictions of the tree at the
;            observed values of the regression variables.
; -----------------------------------------------------------------------
; Example      ; load the library xclust
;              library ("xclust")
; ;let us generate a tree by cartsplit procedure
; x1=#(0,0,0,0,1,1,1,1,1,2)
; x2=#(0,0,0,0,0,0,0,1,1,1)
; x=x1~x2
; y=#(0,0,0,0,100,100,100,120,120,120)
; cs=cartsplit(x,y,#(0,1))
; cs
; val1=ssr(cs,1)
; val1
; prcs=prunetot(cs,2)
; val2=ssr(prcs,1)
; val2
; -----------------------------------------------------------------------
; Result
; Content of object cs.val.split0
; [1,] 0 
; [2,] 1,2 
; Content of object cs.val.split1
; [1,] NaN 
; Content of object cs.val.split2
; [1,] 0 
; Content of object cs.val.split3
; [1,] NaN 
; Content of object cs.val.split4
; [1,] NaN 
; Content of object cs.vec
; [1,] 1.000000 
; [2,] NaN 
; [3,] 2.000000 
; [4,] NaN 
; [5,] NaN 
; Content of object cs.mean
; [1,] 66.000000 
; [2,] 0.000000 
; [3,] 110.000000 
; [4,] 100.000000 
; [5,] 120.000000 
; Content of object cs.ssr
; [1,] 29640.000000 
; [2,] 0.000000 
; [3,] 600.000000 
; [4,] 0.000000 
; [5,] 0.000000 
; Content of object cs.nelem
; [1,] 10.000000 
; [2,] 4.000000 
; [3,] 6.000000 
; [4,] 3.000000 
; [5,] 3.000000 
; 
; Content of object val1
; [1,] 0.000000 
; 
; Content of object prcs.val.split0
; [1,] 0 
; [2,] 1,2 
; Content of object prcs.val.split1
; [1,] NaN 
; Content of object prcs.val.split2
; [1,] NaN 
; Content of object prcs.vec
; [1,] 1.000000 
; [2,] NaN 
; [3,] NaN 
; Content of object prcs.mean
; [1,] 66.000000 
; [2,] 0.000000 
; [3,] 110.000000 
; Content of object prcs.ssr
; [1,] 29640.000000 
; [2,] 0.000000 
; [3,] 600.000000 
; Content of object prcs.nelem
; [1,] 10.000000 
; [2,] 4.000000 
; [3,] 6.000000 
;  
; Content of object val2
; [1,] 600.000000   
; -----------------------------------------------------------------------
; Author       Jussi Klemelae, 980323         
; -----------------------------------------------------------------------
leaf=NaN
epoint=endpoint(tree,node)
sum=0
i=node
while (i <= epoint)
if (tree.vec[i]==leaf)
sum=sum+tree.ssr[i]
;sum=sum+tree.ssr[i]/tree.nelem[i]
endif
i=i+1
endo
y=sum
;y=sum/tree.nelem[1]
endp
