proc(mue,sigma,lambda,mue2,sigma2,jump)=stockest(dat)
; -----------------------------------------------------------------
; Library  	  finance
; -----------------------------------------------------------------
;  See_also       stocksim, stockestsim
; -----------------------------------------------------------------
;   Macro         stockest
; -----------------------------------------------------------------
;   Description   stockest is estimating from a given dataset of
;                 a random process parameters for the following models:
;                 assuming a Wiener Process (model 1),  
;                 assuming a compounded Poisson Jump Process 
;		  mixed with a Wiener Process (model 2)    
; ---------------------------------------------------------------------
; Notes    A jump at time n is detected if the absolute value 
;	   of log( data_(n+1) ) - log ( data_(n) )
;	   is greater than mean(log(data))/50, i.e. if the absolute
;	   return is greater than a threshold depending on the
;	   mean price of the asset.
; -----------------------------------------------------------------
;   Usage         dat=stockest(data)
;   Input         
;     Parameter   data  
;     Definition      n x 1 vector , data of a random process 
;   Output      
;     Parameter   mue  
;     Definition      scalar , increasing rate of return in model 1
;     Parameter   sigma  
;     Definition      scalar , volatility of the returns in model 1
;     Parameter   lambda  
;     Definition      scalar , number of jumps in model 2
;     Parameter   mue2  
;     Definition      scalar , increasing rate of return in the
;										       diffusion part of model 2 
;     Parameter   sigma2  
;     Definition      scalar , volatility of the returns in the
;										       diffusion part of model 2 
;     Parameter   jump  
;     Definition      scalar , volatility for the height of jumps 
;										       in model 2 
; -----------------------------------------------------------------
;   Example   library("finance")
;             data=read("motorola")
;             data=data[,2]
;             dat=stockest(data)
;             dat
; -----------------------------------------------------------------
;   Result      
; Contents of dat.mue
; [1,]   7.0066 
; Contents of dat.sigma
; [1,]   44.191 
; Contents of dat.lambda
; [1,]        4 
; Contents of dat.mue2
; [1,]   3.2302 
; Contents of dat.sigma2
; [1,]   38.819 
; Contents of dat.jump
; [1,]     10.9 
;
; -----------------------------------------------------------------
;   Author    Hrdle, Kleinow   990511
; -----------------------------------------------------------------
  error(cols(dat) > 1, "stockest: data has to have one column")
  n=rows(dat)
  ddat=log(dat[2:n]./dat[1:(n-1)])
  sigma=sqrt(var(ddat))
  mue=mean(ddat)
  ddat=(1:(n-1))~ddat
  hi=.02*mean(log(dat))			// threshold for jump detection
  x0=paf(ddat,abs(ddat[,2])>hi)		// jumps
  x1=paf(ddat,abs(ddat[,2])<=hi)	// diffusion
  lambda=rows(x0)			// expected number of jumps
  spr=mean(abs(x0[,2]))     		// expected height of jumps
  sigma2=sqrt(var(x1[,2]))  		// sigma of diffusion part of model 2
  mue2=mean(x1[,2])		  	// mue of diffusion part of model 2
  mue=100*(exp(mue*365)-1)  		// mue of the rescaled process of model 1
  sigma=100*(exp(sigma*sqrt(365))-1) 	// sigma of the rescaled process of model 1
  mue2=100*(exp(mue2*365)-1)   		// mue of the rescaled process of model 2
  sigma2=100*(exp(sigma2*sqrt(365))-1)  // sigma of the rescaled process of model 2
  jump=100*(exp(spr)-1)			// height of jumps of the rescaled process of model 2
endp
