proc (y) =  tdiff(x, d, k) 
; ----------------------------------------------------------------------
; Library 	  times
; ----------------------------------------------------------------------
;  See_also	  
; ----------------------------------------------------------------------
;   Macro	  tdiff
; ----------------------------------------------------------------------
;   Description   a difference operator for time series
;                 allow multiple differences and seaonal 
;                 difference
; ----------------------------------------------------------------------
;   Usage         y = tdiff(x {,d [, k]})
;   Input 
;     Parameter   x 
;     Definition  vector
;     Parameter   d (optional)
;     Definition  integer; the difference lag x(t)-x(t-d)
;                  default d=1
;     Parameter   k (optional)
;     Definition  integer; the number of differences
;   Output
;     Parameter   y
;     Definition  vector; the differenced time series
;                 y(t)=(1-B^d)^k x(t) where BX(t)=X(t-1)
; ----------------------------------------------------------------------
;   Example       library("times")
;                 x=(1:5)
;                 y=tdiff(x,2)
;                 y
; ----------------------------------------------------------------------
;   Result        Contents of y
;                 [1,]   2 
;                 [2,]   2 
;                 [3,]   2 
; ----------------------------------------------------------------------
;   Author        Rong Chen, Christian Hafner, 970725
; ----------------------------------------------------------------------
  if (exist(d)==0)
     d=1
  endif
  if (exist(k)==0)
    k=1
  endif
  j=0
  while(j<k)
  n = rows(x) 
  x = x[(d+1):n]-x[1:(n-d)] 
  j=j+1  
  endo
  y=x
endp