proc(rotm, tourparam)=tourasimov(tourparamin, prime)
; -----------------------------------------------------------------------
; Library      pp
; -----------------------------------------------------------------------
; See_also     plotgt
; -----------------------------------------------------------------------
; Macro        tourasimov
; -----------------------------------------------------------------------
; Description  Computes a rotation matrix based on the paper by
;              Asimov (1985).
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 970418
; -----------------------------------------------------------------------
  tourparam = tourparamin
  tourparam.ta = tourparam.ta + tourparam.tadt
  rotm = tourparam.tarot
  p = rows(tourparam.tarot)
  i = 0
  k = 0
  while (i<p)
    i = i+1
    j = i
    while (j<p)
      j = j+1
      k = k+1
      c = cos(prime[k]*tourparam.ta)
      s = sin(prime[k]*tourparam.ta)
      r = ((1:p).=trans(1:p))
      r[i,i] = c
      r[j,j] = c
      r[i,j] = s
      r[j,i] = -s
      rotm = r*rotm
    endo
  endo
endp
