
proc (y)=tri(x)

; -----------------------------------------------------------------
; Library       kernel
; -----------------------------------------------------------------
;  See_also     cosi epa gau qua trian uni
; -----------------------------------------------------------------
;   Macro       tri
; -----------------------------------------------------------------
;   Description  tri computes the triweight kernel, multivariate
; -----------------------------------------------------------------
;   Usage        y = tri(x)
;   Input
;     Parameter  x  
;     Definition  n x p matrix
;   Output
;     Parameter  y  
;     Definition  n x 1 matrix
; -----------------------------------------------------------------
;   Example   library("kernel") 
;             x = aseq(-1, 21, 0.1) 
;             y = tri(x) 
;             t=createdisplay(1,1)                                      
;             show(t,1,1,x~y)                                    
; -----------------------------------------------------------------
;   Result    The kernel is pictured  
; -----------------------------------------------------------------
;   Author    Wolfgang Haerdle, Sigbert Klinke, Lijian Yang, 951117   
; -----------------------------------------------------------------

  y=prod(35./32.*(abs(x).<1).*(1-x^2)^3,2)

endp
