proc()=twlesson(usel)
; -----------------------------------------------------------------------
; Library      twave
; -----------------------------------------------------------------------
; See_also     twavemain
; -----------------------------------------------------------------------
; Link         ../tutorials/wavestart.html Wavelet tutorial
; -----------------------------------------------------------------------
; Macro        twlesson
; -----------------------------------------------------------------------
; Description  Starts the twave lessons either interactively
;              or a specific lesson.
; -----------------------------------------------------------------------
; Usage        twlesson(NaN)
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960912
; -----------------------------------------------------------------------
  selhead = "Choose wavelet lesson"
  selitem = "Father/Mother"|"Approximation" | "Data compression"|"Two sines"|"Frequency shift"|"Hard thresholding"|"Soft thresholding"|"Translation invariant"|"Image denoising"
  end = 0
  do
    if (rows(usel).>1)
      sel  = (usel[2].=(1:8))
      usel = usel[1]|usel[3:rows(usel)]
    else
      sel = selectitem (selhead, selitem)
    endif
    end = sum (sel).=0
    if (sel[1])
      usel = twles8(usel)
    endif 
    if (sel[2])
      usel = twles1(usel)
    endif 
    if (sel[3])
      usel = twles2(usel)
    endif 
    if (sel[4])
      usel = twles3(usel)
    endif 
    if (sel[5])
      usel = twles4(usel)
    endif 
    if (sel[6])
      usel = twles5(usel)
    endif
    if (sel[7])
      usel = twles6(usel)
    endif
    if (sel[8])
      usel = twles9(usel)
    endif
    if (sel[9])
      usel = twles7(usel)
    endif
  until (end)
endp
