proc(Variog)=Variogram(x)
; ---------------------------------------------------------------------
; Library     
; ---------------------------------------------------------------------
; See_also    Varplot
; ---------------------------------------------------------------------
; Macro       variogram
; ---------------------------------------------------------------------
; Description Calculation and plot of the variogram, direct plot of
;							(Xi_Xj)^2/abs(i-j)
; ---------------------------------------------------------------------
; Usage       (variog)=variogram(x)
; Input       
; Parameter   x series to be plotted
; Definition  
; Output      
; Parameter   variog matrix of the values for the plot
; Definition  
; ---------------------------------------------------------------------
; Notes       
; ---------------------------------------------------------------------
; Example     x=normal(12)
;							vg=variogram(x)
; ---------------------------------------------------------------------
; Result      Contents of vg
;							[1,]     0        0
;							[2,]     1  0.95418
;							[3,]     2  0.75516
;							[4,]     3  0.88298
;							[5,]     4  1.1897
;							[6,]     5  0.37163
; ---------------------------------------------------------------------
; Keywords    long memory, self similarity, variance
; ---------------------------------------------------------------------
; Reference   Beran, J. "Statistics for Long Memory Processes", Chapman
;							& Hall 1994
; ---------------------------------------------------------------------
; Link        
; ---------------------------------------------------------------------
; Author      Arne Wuensche 000410
; ---------------------------------------------------------------------
//
n=rows(x)
if (n<101)
	maxk=floor(n/2)
else
	maxk=51
endif
i1=0
vk=matrix(maxk,2)-matrix(maxk,2)
while (i1<n)
	i1=i1+1
	i2=i1
	while (i2<n)
		k=i2-i1
		if (k<maxk)
		vk[k+1,1]=k
		vk[k+1,2]=.5*(x[i1]-x[i2])^2/(n-k)+vk[k+1,2]
		endif
		i2=i2+1
	endo
endo
i=0
z1=setmask(vk)
c=createdisplay(1,1)
show(c,1,1,z1)
setgopt(c,1,1,"ylabel","V(k)","xlabel","k")
Variog=vk
endp