proc(beta,s)=varml(x,p)
; -----------------------------------------------------------------
;   Library      multi
; -----------------------------------------------------------------
;   See_also     varunls
; -----------------------------------------------------------------
;   Macro        varml
; -----------------------------------------------------------------
;   Description  computes the maximum likelihood estimates of the
;                model parameters (beta) and covariance (s) of residuals
;                of a VAR(p) model without intercept
;
; -----------------------------------------------------------------
;   Usage        {beta,s}=varml(x,p)   
;   Input
;     Parameter   x 
;     Definition   (p+T x K)-matrix, observations of K-dimensional time series        
;     Parameter   p
;     Definition   scalar,  process order
;   Output                                                           
;     Parameter   beta
;     Definition   (K x K*p) matrix, ML-estimates of the model parameters.
;                  The lagged parameter matrices are stored as B={B(1),B(2),...,B(p)}
;                  where B(i) is the parameter matrix at lag i.
;     Parameter   s
;     Definition   (KxK)-matrix, ML-estimate of covariance matrix of residuals
; -----------------------------------------------------------------
;   Author Benkwitz 980127
; -----------------------------------------------------------------
;
    if (p==0)				; case: var-order is zero
        beta=0
        s=x'*x / rows(x)
    else				; case: var-order is greater zero
	t=rows(x)-p
        z=x[1:t,]'
	if (p>1)
	    i=2
	    do
	      z=x[i:t+i-1,]'|z
	      i=i+1
	    until (i==p+1)
	endif
        x=x[p+1:t+p,]'
        beta=kron(inv(z*z') * z , unit(rows(x))) * vec(x)
        beta=reshape( beta , #(rows(x),rows(x)*p) )
        s=x * (unit(cols(x))-z'*inv(z*z')*z)*x'/cols(x)
    endif
endp



