proc(Varplot,H)=Varplot(x)
; ---------------------------------------------------------------------
; Library     longmemory
; ---------------------------------------------------------------------
; See_also    Variogram, RShurst
; ---------------------------------------------------------------------
; Macro       varplot
; ---------------------------------------------------------------------
; Description Calculation and graphic of variance plot
; ---------------------------------------------------------------------
; Usage       (Varplot,H)=Varplot(x)
; Input       
; Parameter   x series to be estimated
; Definition  
; Output      
; Parameter   varplot values used in the plotting
; Definition 
; Parameter		H from the regression estimated Hurst coefficient
; Definition 
; ---------------------------------------------------------------------
; Notes       
; ---------------------------------------------------------------------
; Example     x=normal(100)
;							vp=Varplot(x)
; ---------------------------------------------------------------------
; Result      Contents of vp.Varplot
;							[ 1,]  1.6094   -1.438
;							[ 2,]  1.7918  -1.5829
;							[ 3,]  1.9459  -2.1908
;							[ 4,]  2.0794  -2.2444
;							[ 5,]  2.1972  -1.9052
;							[ 6,]  2.3026   -2.142
;							[ 7,]  2.3979   -2.171
;							[ 8,]  2.4849  -3.0866
;							[ 9,]  2.6391  -2.7202
;							[10,]  2.7726  -2.7202
;							[11,]  2.9957  -3.1796
;							[12,]  3.2189   -4.317 
;							Contents of vp.H
;							[1,]   0.24676
; ---------------------------------------------------------------------
; Keywords    
; ---------------------------------------------------------------------
; Reference   Beran, J. "Statistics for Long Memory Processes", Chapman
;							& Hall 1994
; ---------------------------------------------------------------------
; Link        
; ---------------------------------------------------------------------
; Author      Arne Wuensche 0004010
; ---------------------------------------------------------------------
//
n=rows(x)
;
a0=5
a=a0-1
teiler1=matrix(n/4)
j=0
i=0
while(a<=floor(n/4))
  a=a+1
    if (floor(n/(a+1))<floor(n/a))
      j=j+1
      teiler1[j]=a
    endif
endo
teiler=matrix(j) 
do 
  i=i+1
  teiler[i]=teiler1[i]
until (i>=j)
;
m=rows(teiler)
i1=0
meank=matrix(m)
s2k=matrix(m,2)
while (i1<m)
	i1=i1+1
	i2=0
	meanxk=matrix(floor(n/teiler[i1]))
	while (i2<floor(n/teiler[i1]))
		i2=i2+1
		i3=0
		xk=matrix(teiler[i1])
		while (i3<teiler[i1])
			i3=i3+1
			xk[i3]=x[(i2-1)*teiler[i1]+i3]
		endo
		meanxk[i2]=mean(xk)
	endo
	meank[i1]=mean(meanxk)
	i4=0
	summe=0
	while (i4<floor(n/teiler[i1]))
		i4=i4+1
		summe=(meanxk[i4]-meank[i1])^2+summe
	endo
	s2k[i1,1]=log(teiler[i1])
	s2k[i1,2]=log(1/(floor(n/teiler[i1])-1)*summe)
endo
{b,bse,bstan,bpval}=linreg(s2k[,1],s2k[,2])
gl=grlinreg(s2k)
y1=setmask(s2k)
y2=setmask(gl)
c=createdisplay(1,1)
show(c,1,1,y1,y2)
setgopt(c,1,1,"ylabel","var(X)","xlabel","X")
Varplot=s2k
H=(b[2]+2)/2
endp