proc()=waveint1b(disp, col, a, b, x, dl)
; -----------------------------------------------------------------------
; Library      twave 
; -----------------------------------------------------------------------
; See_also     waveint2b waveint3b waveint4b waveint5b
; -----------------------------------------------------------------------
; Link         ../tutorials/wavestart.html Wavelet tutorial
; -----------------------------------------------------------------------
; Macro        waveint1b
; -----------------------------------------------------------------------
; Description  Shows the mother wavelet for a given basis.
;              In the picture of the first row the function is shown. 
;	       Below, in the second row, the mother wavelet coefficients
;	       are shown. For each level in a horizontal line are 
;              vertical lines plotted. The length of the vertical line
;              depends on the size of the wavelet coefficient. 
; -----------------------------------------------------------------------
; Usage        waveint1b(disp, col, a, b, x, dl)
; Input
;   Parameter  disp 
;   Definition display
;   Parameter  col
;   Definition scalar		which column of disp is used
;   Parameter  a
;   Definition n x 2    	father wavelet coefficients 
;   Parameter  b
;   Definition m x 3 		mother wavelet coefficients
;   Parameter  x
;   Definition (n+m) x 1	data
;   Parameter  dl
;   Definition scalar           0 function will be drawn as points
;				1 function will be drawn as line
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960916
; -----------------------------------------------------------------------
; max coeff
  mb  = max(abs(b[,3]))
; dataset for the b's
  bx1 = ((0.5+b[,2])./2^b[,1])~b[,1]
  if (mb<1.0e-10)
    bx2 = ((0.5+b[,2])./2^b[,1])~(b[,1]+0.5.*b[,3]./1.0e-10)
  else
    bx2 = ((0.5+b[,2])./2^b[,1])~(b[,1]+0.5.*b[,3]./mb)
  endif
  bx  = bx1|bx2
  bn  = rows(bx1)
  bp  = (1:bn)~(bn+1:2.*bn)
; dataset for the x's 
  xn  = rows(x)
  xx  = (((1:xn)-0.5)./xn)~x
  if (dl)
    setmaskp(xx, 0, 0, 0)
    setmaskl (xx,  (1:rows(xx))', 0, 1, 3)
  endif 
; build coeff
  setmaskp (bx, 0, 0, 0)
  setmaskl (bx, bp, 0, 1, 5)
  show (disp, 1, col, xx)
  show (disp, 2, col, bx)  
  setxaxis (disp, 1, col, -0.05, 1.05, 0, 0.2, 0.1, 0, 1)
  setxaxis (disp, 2, col, -0.05, 1.05, 0, 0.2, 0.1, 0, 1)
  setyaxis (disp, 2, col, min(b[,1])-1, max(b[,1])+1, 0, 1, 0.5, 0, 1)
endp
