proc()=waveint5b(disp, col, c, x)
; -----------------------------------------------------------------------
; Library      twave 
; -----------------------------------------------------------------------
; See_also     waveint1b waveint2b waveint3b waveint4b
; -----------------------------------------------------------------------
; Link         ../tutorials/wavestart.html Wavelet tutorial
; -----------------------------------------------------------------------
; Macro        waveint5b
; -----------------------------------------------------------------------
; Description  Shows the wavelet coefficients for a given basis.
;              In the picture of the first row the bivariate image
;	       is shown.  Below, in the second row, we see the 32 absolute
;              largest father/mother coeffients ordered by size.
; -----------------------------------------------------------------------
; Usage        waveint5b(disp, col, c, x)
; Input
;   Parameter  disp 
;   Definition display
;   Parameter  col
;   Definition scalar,		which column of disp is used
;   Parameter  c
;   Definition n x n     	father/mother wavelet coefficients 
;   Parameter  x
;   Definition n x n     	data
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960916
; -----------------------------------------------------------------------
; max coeff
  s  = rows(c)*cols(c)
  m  = abs(sort(reshape(c, #(s, 1)),  -1))
  mm = max(m)
; dataset for the b's
  if (mm<1.0e-10)
    bx  =  m[1:32]./1.0e-10
  else
    bx  =  m[1:32]./mm
  endif
  cb  =  ((1:rows(bx))~bx)|((1:rows(bx))~(0.*matrix(rows(bx))))
  sb = (1:rows(bx))~((rows(bx)+1):(2*rows(bx)))
; dataset for the x
  n = rows(x)
  reshape("x", #(n*n,1))
  x = (x - min(x) + 0.0001 )./(max(x) - min(x) + 0.0001)
  xn = grid(#(1,1), #(1,(-1)), #(n, n))
  xc = 16*floor(x*15.99)
  freecolor()
  createcolor(xc~xc~xc)
  setmaskp(xn, xc~xc~xc, 1, 1)
; build coeff
  setmaskp (cb, 0, 0, 0)
  setmaskl (cb, sb, 0, 1, 3)
  show (disp, 1, col, xn)
  show (disp, 2, col, cb)  
endp
