proc(v,d,uu,clus)=xchcme(x,c,m,e)
; ---------------------------------------------------------------------
; Library     xclust
; ---------------------------------------------------------------------
; See_also    xcfcme
; ---------------------------------------------------------------------
; Macro       xchcme
; ---------------------------------------------------------------------
; Description   Performs a hard c-means cluster analysis
; ---------------------------------------------------------------------
; Usage         {v,d,uu,clus}=xchcme(x,c,m,e)
; Input       
;   Parameter   x
;   Definition  n x p matrix of n row points to be clustered 
;   Parameter   c
;   Definition  scalar the number of clusters
;   Parameter   m
;   Definition  determines the fuzziness of clustering (m>1)
;   Parameter   e
;   Definition  termination tolerance 
;
; Output      
;   Parameter   v
;   Definition  p x p matrix of cluster centers
;   Parameter   d
;   Definition  n x p matrix of distance 
;   Parameter   uu
;   Definition  n x p matrix of result
;   Parameter   clus
;   Definition  number of cluster
; ---------------------------------------------------------------------
; Example   
; library("xclust")
; z=read("butterfly.dat")
; x=z[,2:3]
; c=2
; m=1
; e=0.001
; hcm=xchcme(x,c,m,e)         ; apply hard-c-means clustering
; hcm.clus
; d=createdisplay(1,1)
; setmaskp(x,hcm.clus,hcm.clus+1,7)
; show(d,1,1,x)
; title="Hard-c-means for Butterfly Data"
; setgopt(d,1,1,"title", title)  
; ---------------------------------------------------------------------
; Result      gives the partitions of membership functions and depicts 
;             the clusters based on these partitions
; ---------------------------------------------------------------------
; Keywords    hard, clustering
; ---------------------------------------------------------------------
; Reference   1. James C. Bezdek "Pattern Recognition with Fuzzy 
;                Objective Function Algorithm",  1981.
;
;             2. James C. Bezdek and Sankar K. Pal "Fuzzy Models for 
;                Pattern Recognition", 1992. 
; ---------------------------------------------------------------------
; Author      Hans-Joachim Mucha, Hizir Sofyan, 000510
; ---------------------------------------------------------------------
; initialize
  max=100
  r=rows(x) 
  cc=cols(x)
  cond=max
  iter=0
  
  randomize(1111)
  u = uniform(r,c)        
  iu = matrix(r,c)
  
  i=1
  while (i <r+1)
    j=1
    tot=0
    iu[i,j]=0
    while (j <c+1)
      tot=tot+u[i,j]
      j = j+1
    endo 
    j=1
    while (j <c+1)
      iu[i,j]=u[i,j]./tot             
      j=j+1 
    endo
    i=i+1
  endo
  
  u= iu'
  
  while (cond.>e  && iter.<max)
    
; calculate cluster center
    num=(u^m)*x
    den=(u^m)*matrix(r,cc)
    v=num./den
    d=matrix(r,c)
    
; calculate distance matrix    
    i=1
    j=1
    while (j<r+1) 
      while (i<c+1)
        d[j,i]=distance(x[j,]|v[i,])[1,2]
        i=i+1  
      endo
      i=1
      j=j+1
    endo
    
; calculate membership function
    
    uu=matrix(c,r)
    
    i=1
    while (i<c+1)
      k=1
      while (k<r+1)
        
        dmin= min(d,cc)'
        
        if (d[k,i]==dmin[i,k])
          
          uu[i,k]=1
        else 
          uu[i,k]=0
        endif
        
        k=k+1
      endo
      
      i=i+1
    endo    
    
    cond=sum(abs(u-uu))
    iter=iter+1
    u=uu
  endo   
  uu=u
  
; determine the clusters
  uu=uu'  
  i=1
  clus=matrix(r)
  while (i<r+1)
    j=1
    k=1
    while (j<=c) 
      if (uu[i,k] == 1)
        clus[i]=j
      endif    
      j=j+1
      k=k+1
    endo
    i=i+1
  endo
endp
