proc(yh)=xgobiisotonic(x,y,g,h)
; -----------------------------------------------------------------------
; Library      rpclib
; -----------------------------------------------------------------------
; See_also     xgobiknn xgobilinreg xgobisknn
; -----------------------------------------------------------------------
; Macro        xgobiisotonic
; -----------------------------------------------------------------------
; Description  conmputes an isotonic fit for XGobi
; -----------------------------------------------------------------------
; Usage        yh = xgobiisotonic(x,y,g,h)
; Input
;   Parameter  x
;   Definition n x 1    matrix
;   Parameter  y
;   Definition n x 1    matrix
;   Parameter  g
;   Definition n x 1    matrix with integers starting at zero
;   Parameter  h
;   Definition scalar   unused
; Output
;   Parameter  yh
;   Definition n x 1    matrix smoothed fit
; -----------------------------------------------------------------------
; Example      ; load the library for XGobi
;	       library ("rpclib")
;              ; create a display
;	       d=createdisplay(1,1)
;	       ; read a data set
;  	       x=read("motcyc")
;              ; generate randomly three subgroups
;  	       g=floor(3.*uniform(rows(x)))
;              ; color the data after the subgroups
;              setmaskp (x, g, 3, 4)
;              ; show the data and the smooth
;              show (d, 1, 1, x, x[,1]~xgobiisotonic(x[,1],x[,2],g))
; -----------------------------------------------------------------------
; Result       shows an isotonic fit for the three different subgroups
;	       in the data
; -----------------------------------------------------------------------
; Link         http://www.public.iastate.edu/~dicook/research/software.html XGobi
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960709
; -----------------------------------------------------------------------
  i  = 0
  mg = 1+max(g)
  yh = y
  k  = 1:rows(x)
  while (i<mg)
    xg = paf(x, g.=i)
    yg = paf(y, g.=i)
    kg = paf(k, g.=i)
    xg = sort(xg~yg~kg)
    yg = xg[,2]
    kg = xg[,3]
    yh[kg] = isoreg(yg)
    i = i+1
  endo
endp
