/* imtqlv.f -- translated by f2c (version 19950110).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Table of constant values */

static doublereal c_b11 = 1.;

/* Subroutine */ int imtqlv_(n, d, e, e2, w, ind, ierr, rv1)
integer *n;
doublereal *d, *e, *e2, *w;
integer *ind, *ierr;
doublereal *rv1;
{
    /* System generated locals */
    integer i__1, i__2;
    doublereal d__1, d__2;

    /* Builtin functions */
    double d_sign();

    /* Local variables */
    static doublereal b, c, f, g;
    static integer i, j, k, l, m;
    static doublereal p, r, s;
    static integer ii;
    extern doublereal pythag_();
    static integer tag, mml;
    static doublereal tst1, tst2;



/*     this subroutine is a variant of  imtql1  which is a translation of 
*/
/*     algol procedure imtql1, num. math. 12, 377-383(1968) by martin and 
*/
/*     wilkinson, as modified in num. math. 15, 450(1970) by dubrulle. */
/*     handbook for auto. comp., vol.ii-linear algebra, 241-248(1971). */

/*     this subroutine finds the eigenvalues of a symmetric tridiagonal */
/*     matrix by the implicit ql method and associates with them */
/*     their corresponding submatrix indices. */

/*     on input */

/*        n is the order of the matrix. */

/*        d contains the diagonal elements of the input matrix. */

/*        e contains the subdiagonal elements of the input matrix */
/*          in its last n-1 positions.  e(1) is arbitrary. */

/*        e2 contains the squares of the corresponding elements of e. */
/*          e2(1) is arbitrary. */

/*     on output */

/*        d and e are unaltered. */

/*        elements of e2, corresponding to elements of e regarded */
/*          as negligible, have been replaced by zero causing the */
/*          matrix to split into a direct sum of submatrices. */
/*          e2(1) is also set to zero. */

/*        w contains the eigenvalues in ascending order.  if an */
/*          error exit is made, the eigenvalues are correct and */
/*          ordered for indices 1,2,...ierr-1, but may not be */
/*          the smallest eigenvalues. */

/*        ind contains the submatrix indices associated with the */
/*          corresponding eigenvalues in w -- 1 for eigenvalues */
/*          belonging to the first submatrix from the top, */
/*          2 for those belonging to the second submatrix, etc.. */

/*        ierr is set to */
/*          zero       for normal return, */
/*          j          if the j-th eigenvalue has not been */
/*                     determined after 30 iterations. */

/*        rv1 is a temporary storage array. */

/*     calls pythag for  dsqrt(a*a + b*b) . */

/*     questions and comments should be directed to burton s. garbow, */
/*     mathematics and computer science div, argonne national laboratory 
*/

/*     this version dated august 1983. */

/*     ------------------------------------------------------------------ 
*/

    /* Parameter adjustments */
    --rv1;
    --ind;
    --w;
    --e2;
    --e;
    --d;

    /* Function Body */
    *ierr = 0;
    k = 0;
    tag = 0;

    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
	w[i] = d[i];
	if (i != 1) {
	    rv1[i - 1] = e[i];
	}
/* L100: */
    }

    e2[1] = 0.;
    rv1[*n] = 0.;

    i__1 = *n;
    for (l = 1; l <= i__1; ++l) {
	j = 0;
/*     .......... look for small sub-diagonal element .......... */
L105:
	i__2 = *n;
	for (m = l; m <= i__2; ++m) {
	    if (m == *n) {
		goto L120;
	    }
	    tst1 = (d__1 = w[m], abs(d__1)) + (d__2 = w[m + 1], abs(d__2));
	    tst2 = tst1 + (d__1 = rv1[m], abs(d__1));
	    if (tst2 == tst1) {
		goto L120;
	    }
/*     .......... guard against underflowed element of e2 ........
.. */
	    if (e2[m + 1] == 0.) {
		goto L125;
	    }
/* L110: */
	}

L120:
	if (m <= k) {
	    goto L130;
	}
	if (m != *n) {
	    e2[m + 1] = 0.;
	}
L125:
	k = m;
	++tag;
L130:
	p = w[l];
	if (m == l) {
	    goto L215;
	}
	if (j == 30) {
	    goto L1000;
	}
	++j;
/*     .......... form shift .......... */
	g = (w[l + 1] - p) / (rv1[l] * 2.);
	r = pythag_(&g, &c_b11);
	g = w[m] - p + rv1[l] / (g + d_sign(&r, &g));
	s = 1.;
	c = 1.;
	p = 0.;
	mml = m - l;
/*     .......... for i=m-1 step -1 until l do -- .......... */
	i__2 = mml;
	for (ii = 1; ii <= i__2; ++ii) {
	    i = m - ii;
	    f = s * rv1[i];
	    b = c * rv1[i];
	    r = pythag_(&f, &g);
	    rv1[i + 1] = r;
	    if (r == 0.) {
		goto L210;
	    }
	    s = f / r;
	    c = g / r;
	    g = w[i + 1] - p;
	    r = (w[i] - g) * s + c * 2. * b;
	    p = s * r;
	    w[i + 1] = g + p;
	    g = c * r - b;
/* L200: */
	}

	w[l] -= p;
	rv1[l] = g;
	rv1[m] = 0.;
	goto L105;
/*     .......... recover from underflow .......... */
L210:
	w[i + 1] -= p;
	rv1[m] = 0.;
	goto L105;
/*     .......... order eigenvalues .......... */
L215:
	if (l == 1) {
	    goto L250;
	}
/*     .......... for i=l step -1 until 2 do -- .......... */
	i__2 = l;
	for (ii = 2; ii <= i__2; ++ii) {
	    i = l + 2 - ii;
	    if (p >= w[i - 1]) {
		goto L270;
	    }
	    w[i] = w[i - 1];
	    ind[i] = ind[i - 1];
/* L230: */
	}

L250:
	i = 1;
L270:
	w[i] = p;
	ind[i] = tag;
/* L290: */
    }

    goto L1001;
/*     .......... set error -- no convergence to an */
/*                eigenvalue after 30 iterations .......... */
L1000:
    *ierr = l;
L1001:
    return 0;
} /* imtqlv_ */

