#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "dll.h"
#include "f2c.h"

#define ERROR_PARAM 10100
#define ERROR_TYPE1 10201
#define ERROR_TYPE2 10202
#define ERROR_TYPE3 10203
#define ERROR_TYPE4 10204
#define ERROR_TYPE5 10205
#define ERROR_TYPE6 10206
#define ERROR_TYPE7 10207
#define ERROR_TYPE8 10208
#define ERROR_TYPE9 10209
#define ERROR_SQUARE 10300
#define ERROR_SYM 10400
#define ERROR_MEM 10500
#define EPS 1.0e-10

#ifdef KR_headers
EXTERN int EXPORT rs(argc, type, ptr)
int argc; int *type; voidp *ptr;
#else
EXTERN int EXPORT rs(int argc, int  *type, voidp *ptr)
#endif
{
   int  ierr, i, j;
	DBL8 *a, *w, *z, *fv1, *fv2;
   INT4 *matz;
	INT8 *n, *nm;

	nm   = (INT8 *) ptr[0];
   n    = (INT8 *) ptr[1];
   a    = (DBL8 *) ptr[2];
	w    = (DBL8 *) ptr[3];
   matz = (INT4 *) ptr[4];
   z    = (DBL8 *) ptr[5];

/* check if the number of arguments given by the user is correct */
	if ( argc != 6)
   	return(ERROR_PARAM);

/* check if the type of the arguments is correct */
	if (type[0] != -8)
		return(ERROR_TYPE1);
   if (type[1] != -8)
		return(ERROR_TYPE2);
	if (type[2] != 8)
		return(ERROR_TYPE3);
	if (type[3] != 8)
		return(ERROR_TYPE4);
	if (type[4] != -4)
		return(ERROR_TYPE5);
	if (type[5] != 8)
		return(ERROR_TYPE6);

/* check if the matrix given by the user is a square matrix */
	if (*nm != *n)
		return(ERROR_SQUARE);

/* check if the matrix is a symmetric matrix */
  	for (i=0; i<*nm; i++)
		{
		for (j=i+1; j<*n; j++)
         {
			if (fabs(a[j*(*nm)+i] - a[i*(*nm)+j])>EPS)
	      	 return(ERROR_SYM);
   		}
		}

/* allocate memory for array used by the eispack-routine rs_() */
   fv1 = (DBL8 *)malloc((*n)*sizeof(DBL8));
	if (fv1==NULL)
		return(ERROR_MEM);

   fv2 = (DBL8 *)malloc((*n)*sizeof(DBL8));
	if (fv2==NULL)
		return(ERROR_MEM);

  	rs_(nm, n, a, w, matz, z, fv1, fv2, &ierr);

	free(fv1);
	free(fv2);

	return(ierr);

}


#ifdef KR_headers
EXTERN int EXPORT cg(argc, type, ptr)
int argc; int *type; voidp *ptr;
#else
EXTERN int EXPORT cg(int argc, int  *type, voidp *ptr)
#endif
{
	int  ierr;
	DBL8 *ar, *ai, *wr, *wi, *zr, *zi;
	DBL8  *fv1, *fv2, *fv3;
   INT4 *matz;
   INT8 *n, *nm;

	nm   = (INT8 *) ptr[0];
   n    = (INT8 *) ptr[1];
   ar   = (DBL8 *) ptr[2];
	ai   = (DBL8 *) ptr[3];
   wr   = (DBL8 *) ptr[4];
   wi   = (DBL8 *) ptr[5];
	matz = (INT4 *) ptr[6];
	zr   = (DBL8 *) ptr[7];
	zi   = (DBL8 *) ptr[8];

/* check if the type of the arguments is correct */
	if (type[0] != -8)
		return(ERROR_TYPE1);
   if (type[1] != -8)
		return(ERROR_TYPE2);
	if (type[2] != 8)
		return(ERROR_TYPE3);
	if (type[3] != 8)
		return(ERROR_TYPE4);
	if (type[4] != 8)
		return(ERROR_TYPE5);
	if (type[5] != 8)
		return(ERROR_TYPE6);
	if (type[6] != -4)
		return(ERROR_TYPE7);
	if (type[7] != 8)
		return(ERROR_TYPE8);
	if (type[8] != 8)
		return(ERROR_TYPE9);

/* check if the number of arguments given by the user is correct */
	if ( argc != 9)
   	return(ERROR_PARAM);

/* allocate memory for array used by the eispack-routine cg_() */
   fv1 = (DBL8 *)malloc((*n)*sizeof(DBL8));
	if (fv1==NULL)
		return(ERROR_MEM);

   fv2 = (DBL8 *)malloc((*n)*sizeof(DBL8));
	if (fv2==NULL)
		return(ERROR_MEM);

	fv3 = (DBL8 *)malloc((*n)*sizeof(DBL8));
	if (fv2==NULL)
		return(ERROR_MEM);


	cg_(nm, n, ar, ai, wr, wi, matz, zr, zi, fv1, fv2, fv3, &ierr);

	free(fv1);
	free(fv2);
	free(fv3);

	return(ierr);

}

#ifdef KR_headers
EXTERN int EXPORT rg(argc, type, ptr)
int argc; int *type; voidp *ptr;
#else
EXTERN int EXPORT rg(int argc, int  *type, voidp *ptr)
#endif
{
int  ierr;
	DBL8 *a, *wr, *wi, *z;
	DBL8  *fv1, *iv1;
   INT4 *matz;
   INT8 *n, *nm;

	nm   = (INT8 *) ptr[0];
   n    = (INT8 *) ptr[1];
   a    = (DBL8 *) ptr[2];
	wr   = (DBL8 *) ptr[3];
   wi   = (DBL8 *) ptr[4];
	matz = (INT4 *) ptr[5];
	z    = (DBL8 *) ptr[6];

/* check if the type of the arguments is correct */
	if (type[0] != -8)
		return(ERROR_TYPE1);
   if (type[1] != -8)
		return(ERROR_TYPE2);
	if (type[2] != 8)
		return(ERROR_TYPE3);
	if (type[3] != 8)
		return(ERROR_TYPE4);
	if (type[4] != 8)
		return(ERROR_TYPE5);
	if (type[5] != -4)
		return(ERROR_TYPE6);
	if (type[6] != 8)
		return(ERROR_TYPE7);

/* check if the number of arguments given by the user is correct */
	if ( argc != 7)
   	return(ERROR_PARAM);

/* allocate memory for array used by the eispack-routine cg_() */
   fv1 = (DBL8 *)malloc((*n)*sizeof(DBL8));
	if (fv1==NULL)
		return(ERROR_MEM);

   iv1 = (DBL8 *)malloc((*n)*sizeof(DBL8));
	if (iv1==NULL)
		return(ERROR_MEM);

	rg_(nm, n, a, wr, wi, matz, z, iv1, fv1, ierr);

	free(fv1);
	free(iv1);

	return(ierr);

}



int main()
{
	int rowdim=3, ord=3, matz=1, i=0;
	double matrix[9], w[3], z[9], fv1[100], fv2[100];
	int ierr;

        matrix[0] = 1;
        matrix[1] = -1;
        matrix[2] = 0;
        matrix[3] = -1;
        matrix[4] = 2;
        matrix[5] = -1;
        matrix[6] = 0;
        matrix[7] = -1;
        matrix[8] = 1;   
        rs_(&rowdim, &ord, &matrix, &w, &matz, &z, &fv1, &fv2, &ierr);

	for (i=0; i<3; i++)
		printf("Eigenvalues: %f\n ", w[i]);

	for (i=0; i<27; i++)
      {
		printf("Eigenvectors: %f\n ", z[i]);

      }
}
