; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also     
; ----------------------------------------------------------------------------
; Macro         flts08
; ----------------------------------------------------------------------------
; Description   Local constant and linear estimate of NAR(2) model 
;		for lynx data
; ----------------------------------------------------------------------------
  library("smoother")
  library("plot")
  setsize(640,480)
;                       data preparation
  lynx		= read("lynx.dat")
  lynxrows	= rows(lynx)
  lag1  	= lynx[1:lynxrows-2]          ; vector of first lag
  lag2  	= lynx[2:lynxrows-1]          ; vector of second lag
  y     	= lynx[3:lynxrows]            ; vector of dep. var.
  data  	= lag1~lag2~y
  data  	= log(data)
;                       estimation
  h 		= 0.2*(max(data[,1])-min(data[,1]))  ; crude bandwidth choice
  mh		= regxestp(data,h)		; local constant estimation
  mhlp 		= lregxestp(data,h)        	; local linear estimation

;                       graphics
  mhplot 	= createdisplay(1,1)
  mh	 	= setmask(mh,"surface","blue")
  show(mhplot,1,1,data,mh)      	; surface plot
  setgopt(mhplot,1,1,"title","Nadaraya-Watson estimate -- ROTATE!")
; rotate view
  m = #(0.38263, -0.18024, 0.90615)
  m = m~#(0.9239, 0.074728, -0.37527)
  m = m~#(-7.5422e-05, 0.98078, 0.19512)
  setgopt (mhplot, 1, 1, "rotcos", m')
;
  mhlpplot	= createdisplay(1,1)
  mhlp 		= setmask(mhlp,"surface","red")
  show(mhlpplot,1,1,data,mhlp)       ; surface plot
  setgopt(mhlpplot,1,1,"title","Local linear estimate -- ROTATE!")
; rotate view
  m=#(0.55558, -0.31818, 0.76817)
  m=m~#(0.83146, 0.21262, -0.51328)
  m=m~#(-1.3575e-05, 0.92388, 0.38269)
  setgopt(mhlpplot,1,1,"rotcos", m')

