; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      intertest2
; ----------------------------------------------------------------------------
; Macro         gam13
; ----------------------------------------------------------------------------
; Description   test for the interaction term using intertest2
; ----------------------------------------------------------------------------
library("gam")
randomize(12345)
n     = 50
t     = uniform(n,3)*2-1
g1    = 2*t[,1]
g2    = t[,2]^2 - mean(t[,2]^2)
g3    = sin(3*t[,3])
g12   = t[,1].*t[,2]
y     = g1+g2+g3+g12+normal(n)*sqrt(0.5)
h     = #(1.1,1.0,0.9)
g     = #(1.2,1.2,1.1)
boot  = 99
hb    = 1.5
weight= matrix(n)-prod((abs(t[,1:2]).>0.85),2)
opt   = list(boot,hb,weight)
test  = intertest2(t,y,h,g,opt)
test
