; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      backfit
; ----------------------------------------------------------------------------
; Macro         gam15
; ----------------------------------------------------------------------------
; Description   analysis of the Wisconsin farm data
; ----------------------------------------------------------------------------
library("xplore")
library("gam")
data=read("animal.dat")
t1 = data[,1]
t2 = data[,2]
t3 = data[,3]
t4 = data[,4]
t=t1~t2~t3~t4
y=read("goods.dat")
h1=0.5*sqrt(cov(t1))
h2=0.5*sqrt(cov(t2))
h3=0.5*sqrt(cov(t3))
h4=0.5*sqrt(cov(t4))
h=h1|h2|h3|h4
g=h
loc=0
opt=gamopt("shf",1)
m = intest(t,y,h,g,loc,opt)
const=mean(y)*0.25
m1 = t[,1]~(m[,1]+const)
m2 = t[,2]~(m[,2]+const)
m3 = t[,3]~(m[,3]+const)
m4 = t[,4]~(m[,4]+const)
setmaskp(m1,4,4,4)
setmaskp(m2,4,4,4)
setmaskp(m3,4,4,4)
setmaskp(m4,4,4,4)
setmaskl(m1,(sort(m1~(1:rows(m1)))[,3])',4,1,1)
setmaskl(m2,(sort(m2~(1:rows(m2)))[,3])',4,1,1)
setmaskl(m3,(sort(m3~(1:rows(m3)))[,3])',4,1,1)
setmaskl(m4,(sort(m4~(1:rows(m4)))[,3])',4,1,1)
yy=y-mean(y)-sum(m,2)
d1=t[,1]~(yy+m[,1])
d2=t[,2]~(yy+m[,2])
d3=t[,3]~(yy+m[,3])
d4=t[,4]~(yy+m[,4])
setmaskp(d1,1,11,4)
setmaskp(d2,1,11,4)
setmaskp(d3,1,11,4)
setmaskp(d4,1,11,4)
pic = createdisplay(2,2)
show(pic,1,1,m1,d1)
show(pic,1,2,m2,d2)
show(pic,2,1,m3,d3)
show(pic,2,2,m4,d4)
kern="qua"
{mb,b,const} = backfit(t,y,h,loc,kern,opt)
m1 = t[,1]~mb[,1]
m2 = t[,2]~mb[,2]
m3 = t[,3]~mb[,3]
m4 = t[,4]~mb[,4]
setmaskp(m1,4,4,4)
setmaskp(m2,4,4,4)
setmaskp(m3,4,4,4)
setmaskp(m4,4,4,4)
setmaskl(m1,(sort(m1~(1:rows(m1)))[,3])',4,1,1)
setmaskl(m2,(sort(m2~(1:rows(m2)))[,3])',4,1,1)
setmaskl(m3,(sort(m3~(1:rows(m3)))[,3])',4,1,1)
setmaskl(m4,(sort(m4~(1:rows(m4)))[,3])',4,1,1)
yy=y-const-sum(mb,2)
d1=t[,1]~(yy+mb[,1])
d2=t[,2]~(yy+mb[,2])
d3=t[,3]~(yy+mb[,3])
d4=t[,4]~(yy+mb[,4])
setmaskp(d1,1,11,4)
setmaskp(d2,1,11,4)
setmaskp(d3,1,11,4)
setmaskp(d4,1,11,4)
pic2 = createdisplay(2,2)
show(pic2,1,1,m1,d1)
show(pic2,1,2,m2,d2)
show(pic2,2,1,m3,d3)
show(pic2,2,2,m4,d4)
