; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      hazsurv
; ----------------------------------------------------------------------------
; Macro         haz08
; ----------------------------------------------------------------------------
; Description   estimates and plots the conditional survival function
;		for simulated data
; ----------------------------------------------------------------------------
 library("hazreg") 
 dat=read("haz01.dat")  
 t = dat[,1]                         ; observed times                      
 delta = dat[,2]                     ; censoring indicator                       
 z = dat[,3:4]                       ; covariates                 
 {data,ties} = hazdat(t,delta, z)    ; preparing data
 z1 = 0.1|-0.3                       ; covariate values
 surv = hazsurv(data, z1)            ; estimate conditional survival function
 
 setsize(600, 400)                   ; initiating graph 
 plot1=createdisplay(1,1)            ; initiating graph 
 n = rows(data)
 pm = (#(1,n+2)'+ (0:n))|(#(2*n+2,3*n+3)'+ (0:n))
                                     ; points to be connected
 cn = matrix(2*n+2)                  ; color_num, controls colors
 ar = matrix(2*n+2)                  ; art, controls line types
 th = matrix(2*n+2)                  ; thick, controls line thickness

 survline = steps4plot(surv, 0~1)    ; points for step function plot
 setmaskl(survline, pm, cn , ar, th) ; lines connected
 setmaskp(survline, 4, 0, 8)         ; points controlled
 setsize(600,400) 
 
 show(plot1, 1, 1, survline)               
 setgopt(plot1, 1, 1, "title","Conditional Survival Function")
 setgopt(plot1, 1, 1, "xlabel","Time", "ylabel","Survival Function")
 setgopt(plot1, 1, 1, "ylim", (0|1.01), "ymajor", 0.2)
; uncomment the following line for a PS picture
; print (plot1,"hazsurvtest.ps") 
