; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      epscontnorm kemitor2
; ----------------------------------------------------------------------------
; Macro         rkalm03
; ----------------------------------------------------------------------------
; Description   shows effect of innovation outliers on Kalman filter
; ----------------------------------------------------------------------------
library("xplore")
library("plot")
library("kalman")
randomize(0)
T = 100
mu=0
H = 1
F = 1
mid=0
Cid=1
mcont=10
Ccont=0.1
eps=0.1
ErrY = normal(T)
ErrX = epscontnorm(T,eps,mid,Cid,mcont,Ccont,0)
sim = kemitor2(T,mu,H,F,ErrY,ErrX)
state = (1:100)~(sim.X)
obs= (1:100)~(sim.Y)
ind = ErrX.Ind
ind = (1:100)~ind
ind[,2]=0
setmaskp(ind,4, 3, 8)  
state=setmask(state,"line","blue","thin")          
obs=setmask(obs,"line","green","thin")          
disp = createdisplay(1,1)
show(disp,1,1,state,obs,ind)
setgopt(disp,1,1, "title", "State Space Model (1 - dim steady state) under IO")
setgopt(disp,1,1, "xlabel", "t") 
setgopt(disp,1,1, "ylabel", "x, y") 
