; -----------------------------------------------------------------             
; Library        xlg                                                            
; -----------------------------------------------------------------             
;  See_also                                                                     
; -----------------------------------------------------------------
;   Macro        graph26
; -----------------------------------------------------------------
;   Description  Plotting colored lines.
; -----------------------------------------------------------------
  library("plot")                ; loads library plot
  xmin = 0                       ; grid minimum 
  xmax = 2*pi                    ; grid maximum
  n    = 100                     ; number of grid points
  x  = xmin + (xmax-xmin)/(n-1) .* (0:n-1)  ; generates grid
  y1 = sin(x)                    ; computes sin(x)
  y2 = sin(3.*x)                 ; computes sin(3x)
  y3 = sin(6.*x)                 ; computes sin(6x)
  plot(x~y1, x~y2, x~y3)         ; plots the data sets
  z1 = setmask(x~y1, "line", "red")   ; red line for sin(x)
  z2 = setmask(x~y2, "line", "green") ; green line for sin(3x)
  z3 = setmask(x~y3, "line", "blue")  ; blue line for sin(6x)
  plot(z1, z2, z3)               ; plots lines






