; -----------------------------------------------------------------             
; Library        xlg                                                            
; -----------------------------------------------------------------             
;  See_also                                                                     
; -----------------------------------------------------------------
;   Macro        graph45
; -----------------------------------------------------------------
;   Description  Linear regression graphics.
; -----------------------------------------------------------------
  library("plot")                ; loads library plot
  data = read ("bostonh")        ; reads Boston Housing data
  x0 = data[,13:14]              ; selects columns 13 and 14
  l0 = grlinreg(x0)              ; generates regression line
  x1 = log(data[,13:14])         ; logarithm of columns 13 and 14
  l1 = grlinreg(x1)              ; generates regression line
  d  = createdisplay(1,2)        ; creates display with two plots
  show (d, 1, 1, x0, l0)         ; plots data and regression l0
  show (d, 1, 2, x1, l1)         ; plots data and regression l1


