; -----------------------------------------------------------------             
; Library        xlg                                                            
; -----------------------------------------------------------------             
;  See_also                                                                     
; -----------------------------------------------------------------
;   Macro        metric06
; -----------------------------------------------------------------
;   Description  Illustrates estimation of a semiparametric 
;                self selection model.
; -----------------------------------------------------------------
library("metrics")
randomize(66666)
n	= 200				
ss1	= #(1,0.9)~#(0.9,1)		
g	= #(1)				
b	= #(-9, 1)			
u	= gennorm(n, #(0,0), ss1)	
ss2     = #(1,0.4)~#(0.4,1)	
xz      = gennorm(n, #(0,0), ss2)       
z       = xz[,2]			
q       = (z*g+u[,1].>=0)		
hd	= 0.1*(max(z) - min(z))		
d	= dwade(z,q,hd)*(2*sqrt(3)*pi)	
id	= z*d				
h       = (quantile(id, 0.7))|(0.2*(max(id) - min(id)))	
x	= matrix(n)~xz[,1]	
y       = x*b+u[,2]		
zz	= paf(y~x~id, q)		
y	= zz[,1]
x	= zz[,3:(cols(zz)-1)]
id	= zz[,cols(zz)]
{a,b}	= select(x,y,id,h)
d~a~b	; first-step estimate ~  intercept estimate ~ slope estimate				
