; -----------------------------------------------------------------             
; Library        xlg                                                            
; -----------------------------------------------------------------             
;  See_also                                                                     
; -----------------------------------------------------------------
;   Macro        smoo01
; -----------------------------------------------------------------
;   Description  Visualizes the kernel density estimator as a
;                sum of bumps.
; -----------------------------------------------------------------
  library("smoother")
  library("plot")
  setsize(640,480)
;
  randomize(2)
  n=10
  h=0.22
  x=normal(n)
  xr=max(x)-min(x)
  ng=100
  xg=grid(min(x)-3.5.*h,(xr+7*h)./(ng-1),ng)
  ;
  proc()=plotkde(x,h,xg)
    kh=pdfn((xg-x')./h)./(rows(x).*h)
    fh=xg~sum(kh,2)
    fh=setmask(fh,"line")
    x=setmask(x~(-0.025 .*matrix(rows(x))),"red","cross")
    d=createdisplay(1,1)
    show(d,1,1,fh,x)
    i=0
    while (i<rows(x))
      i=i+1
      wh=setmask(xg~kh[,i],"line","thin","blue")
      adddata(d,1,1,wh)
    endo
    tl="Construction of Kernel Density"
    xl="Data x"
    yl="Density Estimate fh, Weights Kh"
    setgopt(d,1,1,"xlabel",xl,"ylabel",yl,"title",tl)
  endp
  ;
  plotkde(x,h,xg)






