; -----------------------------------------------------------------             
; Library        xlg                                                            
; -----------------------------------------------------------------             
;  See_also                                                                     
; -----------------------------------------------------------------
;   Macro        smoo03
; -----------------------------------------------------------------
;   Description  Kernel density estimation (by exact computation 
;                on a grid of 30 points).
; -----------------------------------------------------------------
  library("smoother")
  library("plot")
  setsize(640,480)
;
  netinc=read("nicfoo")
  netinc=netinc[,1]
  h=(max(netinc)-min(netinc))*0.15
  v=grid( min(netinc), (max(netinc)-min(netinc))/29, 30)
  fh=denxest(netinc,h,"qua",v)
;
  fh=setmask(fh,"line","blue")
  plot(fh)
  tl="Exact Density Estimate (on Grid)"
  xl="netincome"
  yl="density fh"
  setgopt(plotdisplay,1,1,"title",tl,"xlabel",xl,"ylabel",yl)

