; -----------------------------------------------------------------             
; Library        xlg                                                            
; -----------------------------------------------------------------             
;  See_also                                                                     
; -----------------------------------------------------------------
;   Macro        smoo09
; -----------------------------------------------------------------
;   Description  Residuals from kernel regression estimation 
;                (using exact computation).
; -----------------------------------------------------------------
  library("smoother")
  library("plot")
  setsize(640,480)
;
  nicfoo=read("nicfoo")
  h=0.2*(max(nicfoo[,1])-min(nicfoo[,1]))
;
  mh=regxest(nicfoo,h)
  res=nicfoo[,1] ~ (nicfoo[,2]-mh[,2])
  res=setmask(res,"cross")
  zline=(min(nicfoo[,1])|max(nicfoo[,1])) ~ (0|0)
  zline=setmask(zline,"line","red")
  plot(res,zline)
  setgopt(plotdisplay,1,1,"title","Regression Residuals")  
