; -----------------------------------------------------------------             
; Library        xlg                                                            
; -----------------------------------------------------------------             
;  See_also                                                                     
; -----------------------------------------------------------------
;   Macro        smoo11
; -----------------------------------------------------------------
;   Description  Computes pointwise confidence intervals and 
;                uniform confidence bands in univariate 
;                regression.
; -----------------------------------------------------------------
  library("smoother")
  library("plot")
  setsize(640,480)
;
  nicfoo=read("nicfoo")
;
  {mh,mli,mui}=regxci(nicfoo,0.18)  ; intervals
  {mh,mlb,mub}=regxcb(nicfoo,0.18)  ; bands
  mh =setmask(mh,"line","blue","thick")
  mli=setmask(mli,"line","blue","thin","dashed")
  mui=setmask(mui,"line","blue","thin","dashed")
  mlb=setmask(mlb,"line","blue","thin")
  mub=setmask(mub,"line","blue","thin")
  plot(mh,mli,mui,mlb,mub)
  setgopt(plotdisplay,1,1,"title","Confidence Intervals & Bands")
