; -----------------------------------------------------------------             
; Library        xlg                                                            
; -----------------------------------------------------------------             
;  See_also                                                                     
; -----------------------------------------------------------------
;   Macro        smoo14
; -----------------------------------------------------------------
;   Description  Computes a three-dimensional density estimate and 
;                plots the contours in 3D.
; -----------------------------------------------------------------
  library("smoother")
  library("plot")
  setsize(640,480)
;
  bank    = read("bank2.dat") 
  bank456 = bank[,4:6]                ; columns 4 to 6
  fh = denxestp(bank456,1.5)
  axesoff()
  fhr  = (max(fh[,4])-min(fh[,4]))    ; range of fh
  cf1= grcontour3(fh,0.4*fhr,2)       ; contours
  cf2= grcontour3(fh,0.6*fhr,4)       ; contours
  cu = grcube(cf1)                    ; box
  plot(cu.box, cf1,cf2)               ; graph contours
  setgopt(plotdisplay,1,1,"title","3D Density Estimate")
  axeson()
