; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      tp/cafpe/cafpefull tp/cafpe/cafpe tp/cafpe/plotloclin
; ----------------------------------------------------------------------------
; Macro         flts13
; ----------------------------------------------------------------------------
; Description   plots conditional mean function for lags 1, 3, autocorrelation
;               function of residuals and uses these residuals to select 
;		lags of nonlinear conditional volatility function 
;               for exchange rate returns using CAFPE criterion
; ----------------------------------------------------------------------------
  pathcafpe    = "tp/cafpe/"  ; path for CAFPE quantlets

;    load required libraries
  library("xplore")
  library("times")
  func("jarber")
  func(pathcafpe + "cafpeload") ;load required XploRe files of CAFPE
  cafpeload(pathcafpe)
;   set output format
  setsize(640,480)
  setenv("outheadline","") 	; no header for each output file
  setenv("outlineno","")    	; no numbering of output lines
;   load data
  x     	= read("dmus58-300.dat")  ; name of data file
  y		= tdiff(x)	; compute first differences
  xresid	= 0
  truedat       = ""       	; name of potential data file
  trueres 	= ""		; name of potential residuals file
  xdataln   	= "no"     	; don't take logarithms
  xdatadif  	= "no"    	; don't take first differences
  xdatastand    = "no"     	; don't standardize data
  lagmax    	= 6     	; the largest lag considered is 6
  searchmethod  = "full"    	; consider all possible lag combinations
  dmax      	= 6     	; consider at most 6 lags
  volat 	= "no"		; conduct lag selection for cond. volatility
  selcrit	= "lqcafpe"	; use CAFPE with plug-in bandwidth
  robden    	= "yes"		; robustify density estimation
  perA  	= 0
  perB  	= 0.05		; screen off data with lowest density
  startval	= "different"
  noutputf	= ""		; name of output file
  outpath	= "test"	; path for output file

  lags      	= 1|3          	; lag vector for regression function
  h		= 0
  xsconst   	= 1e-100|1e-100	; 1e-100 for the lags which are varied
                                ; for those kept fixed it includes the
                                ; chosen constant
  gridnum   	= 30           	; number of gridpoints in one direction
   gridmax   	= 0.0015	; maximum of grid
  gridmin	= -0.0015	; minimum of grid

; compute optimal bandwidth and plot cond. mean for given lags
 { hplugin,hB,hC,xs,resid } = plotloclin(y,xresid,xdataln,xdatadif,xdatastand,volat,lags,h,xsconst,gridnum,gridmax,gridmin)
  "plug-in bandwidth for conditional mean" hplugin

; 	diagnostics
  acfplot(resid)		; compute and plot autocorrelation function of residuals
  {jb,probjb,sk,k} = jarber(resid,1)
				; compute Jarque-Bera test for normality of residuals

;   conduct lag selection
  xresid	= resid 
  volat		= "resid"
  {crmin,crpro,crstore,crstoreadd,hstore,hstoretest}= cafpefull(y,truedat,xresid,trueres,xdataln,xdatadif,xdatastand,lagmax,volat,searchmethod,dmax,selcrit,robden,perA,perB,startval,noutputf,outpath)
  "Lag selection for cond. standard deviation using residuals"
  "selected lag vector,               estimated CAFPE "
  crmin[,1:dmax+1]
  "number of lags, chosen lag vector,        estimated CAFPE, plug-in bandwidth"
  (0:dmax)~crpro[,1:dmax|(dmax+4)|(dmax+1)]
; rotate view
  m = #(0.92388, -0.14644, 0.35355)
  m = m~#(0.38268, 0.35357, -0.85355)
  m = m~#(-6.2479e-06, 0.92388, 0.38269)
  setgopt(d1,1,1,"rotcos", m')


  