; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      intest
; ----------------------------------------------------------------------------
; Macro         gam02
; ----------------------------------------------------------------------------
; Description   estimates additive model for simulated data
; ----------------------------------------------------------------------------
library("gam")
randomize(1234)
t     = uniform(50,2)*2-1
g1    = 2*t[,1]
g2    = t[,2]^2
g2    = g2 - mean(g2)
y     = g1 + g2  + normal(50,1) * sqrt(0.25)
h     = #(1.2, 1.0)
g     = #(1.4, 1.2)
loc   = 1
gest  = intest(t,y,h,g,loc)
gest
bild  = createdisplay(1,2)
dat11 = t[,1]~g1
dat12 = t[,1]~gest[,1]
dat21 = t[,2]~g2
dat22 = t[,2]~gest[,2]
setmaskp(dat12,4,4,8)
setmaskp(dat22,4,4,8)
show(bild,1,1,dat11,dat12)
show(bild,1,2,dat21,dat22)
