; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      intestpl
; ----------------------------------------------------------------------------
; Macro         gam03
; ----------------------------------------------------------------------------
; Description   estimates additive partially linear model for simulated data
; ----------------------------------------------------------------------------
library("gam")
randomize(1345)
loc= 2
x = matrix(50,2)
t = uniform(50,2)*2-1
xh = uniform(50,2)
x[,1]= 3*(xh>=0.8)+2*((0.8>xh)&&(xh>=0.3))+(0.3>xh)
x[,2]= (xh>(1/3))
g1    = 2*t[,1]
g2    = (2*t[,2])^2
g2    = g2 -mean(g2)
m     = g1 + g2 + x*(0.2|-1.0)
y     = m + normal(50,1)*0.25
h     = #(1.4, 1.4)
g     = #(1.4, 1.4)
{m,b,const} = intestpl(x,t,y,h,g,loc)
b
const
bild =createdisplay(1,2)
dat11= t[,1]~g1
dat12= t[,1]~m[,1]
setmaskp(dat12,4,4,8)
show(bild,1,1,dat11,dat12)
dat21= t[,2]~g2
dat22= t[,2]~m[,2]
setmaskp(dat22,4,4,8)
show(bild,1,2,dat21,dat22)
