; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      gintest
; ----------------------------------------------------------------------------
; Macro         gam05
; ----------------------------------------------------------------------------
; Description   estimates GAM for simulated data
; ----------------------------------------------------------------------------
library("gam")
randomize(1235)
n     = 100
p     = 2
t     = uniform(n,p)*2-1
g1    = 2*t[,1]
g2    = t[,2]^2
g2    = g2 - mean(g2)
m     = g1 + g2
y     = cdfn(m) .> uniform(n)    ; probit model
h     = #(1.7, 1.5)
g     = #(1.7, 1.5)
tg    = grid(-0.8,0.1,19)
opt   = gamopt("tg",tg~tg,"shf",1)
loc   = 1
code  = "bipro"
m     = gintest(code,t,y,h,g,loc,opt)
d1    = tg[,1]~m[,1]
d2    = tg[,2]~m[,2]
setmaskp(d1,4,4,8)
setmaskp(d2,4,4,8)
bild  = createdisplay(1,2)
show(bild,1,1,d1,t[,1]~g1)
show(bild,1,2,d2,t[,2]~g2)
