; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      gintestpl
; ----------------------------------------------------------------------------
; Macro         gam06
; ----------------------------------------------------------------------------
; Description   estimates generalized additive partially linear model for
;		for simulated data
; ----------------------------------------------------------------------------
library("gam")
randomize(1235)
n     = 100
p     = 2
d     = 2
b     = 1|2
t     = uniform(n,p)*2-1
x     = 2.*uniform(n,d)-1
g1    = 2*t[,1]
g2    = t[,2]^2
g2    = g2 - mean(g2)
m     = g1 + g2
y     = cdfn(m+x*b) .> uniform(n)    ; probit model
h     = #(1.7, 1.5)
g     = #(1.7, 1.5)
tg    = grid(-0.8,0.1,18)
opt   = gamopt("tg",tg~tg)
opt   = gamopt("shf",1,opt)
code  = "bipro"
{m,b,bv,c} = gintestpl(code,x,t,y,h,g,opt)
gamout(t,y,m,b,c,gamopt("pl",1,"x",x,"bv",bv,opt))      
