; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      interact
; ----------------------------------------------------------------------------
; Macro         gam08
; ----------------------------------------------------------------------------
; Description   estimates additive model with interaction term for simulated
;		data
; ----------------------------------------------------------------------------
library("gam")
randomize(12345)
t     = grid(#(-0.9,-0.9),#(0.2,0.2),#(10,10))
n     = rows(t)
t     = t~(uniform(n)*2-1)
g1    = 2*t[,1]
g2    = t[,2]^2 - mean(t[,2]^2)
g3    = sin(3*t[,3])
g12   = t[,1].*t[,2]
y     = g1+g2+g3+g12+normal(n)*sqrt(0.5)
h     = #(0.9, 0.9, 0.9)
g     = #(1.0, 1.0, 1.0)
incl  = 1~2
f     = interact(t,y,h,g,1,incl)
library("graphic")
pic   = createdisplay(2,2)
dat11 = sort(t[,2]~g2)
datf1 = sort(t[,2]~f.fh[,2])
dat12 = sort(t[,3]~g3)
datf2 = sort(t[,3]~f.fh[,3])
setmaskp(dat11,1,3,8)
setmaskp(dat12,1,3,8)
setmaskp(datf1,4,3,8)
setmaskp(datf2,4,3,8)
setmaskl(datf1,(1:rows(datf1))',4,1,1)
setmaskl(datf2,(1:rows(datf2))',4,1,1)
show(pic,1,1,dat11,datf1)
show(pic,1,2,dat12,datf2)
dat21 = grsurface(t[,1:2]~g12)
dat22 = grsurface(t[,1:2]~f.fh[,4])
gc = grcube( dat21|dat22 )
show(pic,2,1,dat21,gc.box,gc.x,gc.y,gc.z,gc.c)
show(pic,2,2,dat22,gc.box,gc.x,gc.y,gc.z,gc.c)
; rotate view
m=#(-0.70709,-0.70712,1.1545e-5)~#(0.50001,-0.49997,0.70712)~#(-0.50002, 0.5,0.70709)
setgopt(pic, 2, 1, "rotcos", m)
setgopt(pic, 2, 2, "rotcos", m)

