; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      randomize gplmopt gplmbootstraptest
; ----------------------------------------------------------------------------
; Macro         gplm06
; ----------------------------------------------------------------------------
; Description   Testing the GLM (with linear index + interaction)  
;               against the GPLM. The GPLM estimation for the 
;               Credit data uses profile likelihood.
; ----------------------------------------------------------------------------
  file=read("kredit")  
  file=paf(file,(file[,5]>=1)&&(file[,5]<=3)) 
                                     ; purpose=car/furniture
  y=file[,1]
  x=(file[,4]>2)                     ; previous loans o.k.
  x=x~(file[,8]>2)                   ; employed (>=1 year)
  x=x~(file[,3])                     ; duration of loan
  t=(file[,6])                       ; amount of loan
  t=t~(file[,14])                    ; age of client
  xvars="previous"|"employed"|"duration"
  tvars="amount"|"age"
;
  t=log(t)               ; logs of amount and age
  trange=max(t)-min(t)
  t=(t-min(t))./trange   ; transformation to [0,1]
;
  library("glm")
;
  n=rows(x)
  opt=glmopt("xvars",xvars|tvars|"interact"|"constant")
  tdesign=t~prod(t,2)~matrix(n)
  l=glmest("bilo",x~tdesign,y,opt)
  glmout("bilo",x~tdesign,y,l.b,l.bv,l.stat,opt)
;
  library("gplm")
;
  h=0.4
  nboot=10
  randomize(742742)
  opt=gplmopt("meth",1,"shf",1,"xvars",xvars)
  opt=gplmopt("tdesign",tdesign,opt)
  opt=gplmopt("wr",prod((abs(t-0.5) < 0.40*trange),2),opt)
  g=gplmbootstraptest("bilo",x,t,y,h,nboot,opt)
  gplmout("bilo",x,t,y,h,g.b,g.bv,g.m,g.stat,opt)
;
  g.alpha





